"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDataService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @public */

class AddDataService {
  constructor() {
    (0, _defineProperty2.default)(this, "addDataTabs", {});
  }
  setup() {
    return {
      /**
       * Registers a component that will be rendered as a new tab in the Add data page
       */
      registerAddDataTab: tab => {
        if (this.addDataTabs[tab.id]) {
          throw new Error(`Tab ${tab.id} already exists`);
        }
        this.addDataTabs[tab.id] = tab;
      }
    };
  }
  getAddDataTabs() {
    return Object.values(this.addDataTabs);
  }
}
exports.AddDataService = AddDataService;