"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ensureCorrectAgentlessSettingsIds = ensureCorrectAgentlessSettingsIds;
var _pMap = _interopRequireDefault(require("p-map"));
var _constants = require("../constants");
var _agent_policy = require("./agent_policy");
var _agentless_agent = require("./agents/agentless_agent");
var _fleet_server_host = require("./fleet_server_host");
var _output = require("./output");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function ensureCorrectAgentlessSettingsIds(esClient) {
  var _await$internalSoClie, _await$internalSoClie2, _await$internalSoClie3;
  const {
    outputId: correctOutputId,
    fleetServerId: correctFleetServerId
  } = _agentless_agent.agentlessAgentService.getDefaultSettings();
  let fixOutput = false;
  let fixFleetServer = false;
  if (!correctOutputId && !correctFleetServerId) {
    return;
  }
  const agentPolicySavedObjectType = await (0, _agent_policy.getAgentPolicySavedObjectType)();
  const internalSoClientWithoutSpaceExtension = _.appContextService.getInternalUserSOClientWithoutSpaceExtension();
  const agentlessDataOutputIdsToFix = correctOutputId ? (_await$internalSoClie = await internalSoClientWithoutSpaceExtension.find({
    type: agentPolicySavedObjectType,
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    filter: `${agentPolicySavedObjectType}.attributes.supports_agentless:true AND NOT ${agentPolicySavedObjectType}.attributes.data_output_id:${correctOutputId}`,
    fields: [`id`],
    namespaces: ['*']
  })) === null || _await$internalSoClie === void 0 ? void 0 : _await$internalSoClie.saved_objects.map(so => so.id) : [];
  const agentlessMonitoringOutputIdsToFix = correctOutputId ? (_await$internalSoClie2 = await internalSoClientWithoutSpaceExtension.find({
    type: agentPolicySavedObjectType,
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    filter: `${agentPolicySavedObjectType}.attributes.supports_agentless:true AND NOT ${agentPolicySavedObjectType}.attributes.monitoring_output_id:${correctOutputId}`,
    fields: [`id`],
    namespaces: ['*']
  })) === null || _await$internalSoClie2 === void 0 ? void 0 : _await$internalSoClie2.saved_objects.map(so => so.id) : [];
  const agentlessFleetServerIdsToFix = correctFleetServerId ? (_await$internalSoClie3 = await internalSoClientWithoutSpaceExtension.find({
    type: agentPolicySavedObjectType,
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    filter: `${agentPolicySavedObjectType}.attributes.supports_agentless:true AND NOT ${agentPolicySavedObjectType}.attributes.fleet_server_host_id:${correctFleetServerId}`,
    fields: [`id`],
    namespaces: ['*']
  })) === null || _await$internalSoClie3 === void 0 ? void 0 : _await$internalSoClie3.saved_objects.map(so => so.id) : [];
  try {
    // Check that the output ID exists
    if (correctOutputId && ((agentlessDataOutputIdsToFix === null || agentlessDataOutputIdsToFix === void 0 ? void 0 : agentlessDataOutputIdsToFix.length) > 0 || (agentlessMonitoringOutputIdsToFix === null || agentlessMonitoringOutputIdsToFix === void 0 ? void 0 : agentlessMonitoringOutputIdsToFix.length) > 0)) {
      const output = await _output.outputService.get(correctOutputId);
      fixOutput = output != null;
    }
  } catch (e) {
    // Silently swallow so that output will not be fixed if the correct output ID does not exist
  }
  try {
    // Check that the fleet server host ID exists
    if (correctFleetServerId && (agentlessFleetServerIdsToFix === null || agentlessFleetServerIdsToFix === void 0 ? void 0 : agentlessFleetServerIdsToFix.length) > 0) {
      const fleetServerHost = await _fleet_server_host.fleetServerHostService.get(correctFleetServerId);
      fixFleetServer = fleetServerHost != null;
    }
  } catch (e) {
    // Silently swallow so that fleet server host will not be fixed if the correct fleet server host ID does not exist
  }
  const allIdsToFix = Array.from(new Set([...(fixOutput ? agentlessDataOutputIdsToFix : []), ...(fixOutput ? agentlessMonitoringOutputIdsToFix : []), ...(fixFleetServer ? agentlessFleetServerIdsToFix : [])]));
  if (allIdsToFix.length === 0) {
    return;
  }
  _.appContextService.getLogger().debug(`Fixing output and/or fleet server host IDs on agent policies: ${allIdsToFix}`);
  await (0, _pMap.default)(allIdsToFix, agentPolicyId => {
    return _agent_policy.agentPolicyService.update(internalSoClientWithoutSpaceExtension, esClient, agentPolicyId, {
      data_output_id: correctOutputId,
      monitoring_output_id: correctOutputId,
      fleet_server_host_id: correctFleetServerId
    }, {
      force: true
    });
  }, {
    concurrency: _constants.MAX_CONCURRENT_AGENT_POLICIES_OPERATIONS
  });
}