"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Wrapper = exports.WithoutHeaderLayout = exports.Page = exports.ContentWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/layouts/without_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Wrapper = exports.Wrapper = _styledComponents.default.div`
  background-color: ${props => props.theme.eui.euiColorEmptyShade};

  // Set the min height to the viewport size minus the height of any global Kibana headers
  min-height: var(--kbn-application--content-height);
`;
const Page = exports.Page = (0, _styledComponents.default)(_eui.EuiPage)`
  background: ${props => props.theme.eui.euiColorEmptyShade};
  width: 100%;
  align-self: center;
  margin: auto;
  flex: 1;
`;
const ContentWrapper = exports.ContentWrapper = _styledComponents.default.div`
  height: 100%;
  padding-left: ${props => props.theme.eui.euiSizeM};
  padding-right: ${props => props.theme.eui.euiSizeM};
`;
const WithoutHeaderLayout = ({
  restrictWidth,
  children
}) => /*#__PURE__*/_react.default.createElement(Wrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(Page, {
  restrictWidth: restrictWidth || 1200,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(ContentWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 11
  }
}), children))));
exports.WithoutHeaderLayout = WithoutHeaderLayout;