"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasDocumentation = exports.DocumentationPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../../../hooks");
var _services = require("../../../../../../../../common/services");
var _side_bar_column = require("../../../components/side_bar_column");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/documentation/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getInputs = ({
  packageInfo,
  integration
}) => {
  var _packageInfo$policy_t;
  return (_packageInfo$policy_t = packageInfo.policy_templates) === null || _packageInfo$policy_t === void 0 ? void 0 : _packageInfo$policy_t.reduce((acc, policyTemplate) => {
    if (integration && policyTemplate.name !== integration) {
      return acc;
    }
    if ('inputs' in policyTemplate && policyTemplate.inputs) {
      return [...acc, ...policyTemplate.inputs.map(input => ({
        key: `${policyTemplate.name}-${input.type}`,
        ...input,
        streams: (0, _services.getStreamsForInputType)(input.type, packageInfo, [])
      }))];
    }
    return acc;
  }, []);
};
const hasDocumentation = ({
  packageInfo,
  integration
}) => {
  if (packageInfo.vars && packageInfo.vars.length > 0) {
    return true;
  }
  if ((getInputs({
    packageInfo,
    integration
  }) || []).length > 0) {
    return true;
  }
};
exports.hasDocumentation = hasDocumentation;
const DocumentationPage = ({
  packageInfo,
  integration
}) => {
  const {
    docLinks
  } = (0, _hooks.useStartServices)();
  const showDocumentation = hasDocumentation({
    packageInfo,
    integration
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_side_bar_column.SideBarColumn, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.description",
    defaultMessage: "This documents all the inputs, streams, and variables available to use this integration programmatically via the Fleet Kibana API. {learnMore}",
    values: {
      learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.api,
        external: true,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.learnMoreLink",
        defaultMessage: "Learn more",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }), showDocumentation ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(PackageVars, {
    vars: packageInfo.vars,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(Inputs, {
    packageInfo: packageInfo,
    integration: integration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.epm.packageDetails.apiReference.noDocumentationMessage",
      defaultMessage: "This integration has no references available.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  })));
};
exports.DocumentationPage = DocumentationPage;
const StreamsSection = ({
  streams
}) => {
  if (streams.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.streamsTitle",
    defaultMessage: "Streams",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }), streams.map(dataStream => /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    key: dataStream.data_stream.type + dataStream.data_stream.dataset,
    id: dataStream.data_stream.type + dataStream.data_stream.dataset,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    }, dataStream.data_stream.dataset), "(", dataStream.title, ")"),
    initialIsOpen: false,
    paddingSize: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, dataStream.description), dataStream.vars ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(VarsTable, {
    vars: dataStream.vars,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  })) : null)));
};
const Inputs = ({
  packageInfo,
  integration
}) => {
  var _inputs$map;
  const inputs = (0, _react.useMemo)(() => getInputs({
    packageInfo,
    integration
  }), [packageInfo, integration]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.inputsTitle",
    defaultMessage: "Inputs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }), (_inputs$map = inputs === null || inputs === void 0 ? void 0 : inputs.map(input => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      key: input.key,
      id: input.key,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 17
        }
      }, input.key), "(", input.title, ")"),
      initialIsOpen: false,
      paddingSize: 'm',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 13
      }
    }, input.description), input.vars ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(VarsTable, {
      vars: input.vars,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 17
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(StreamsSection, {
      streams: input.streams,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 13
      }
    }));
  })) !== null && _inputs$map !== void 0 ? _inputs$map : null);
};
const PackageVars = ({
  vars
}) => {
  if (!vars) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.globalVariablesTitle",
    defaultMessage: "Package variables",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(VarsTable, {
    vars: vars,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }));
};
const VarsTable = ({
  vars
}) => {
  const columns = (0, _react.useMemo)(() => {
    return [{
      field: 'name',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnKeyName",
        defaultMessage: "Key",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 237,
          columnNumber: 11
        }
      }),
      render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 242,
          columnNumber: 35
        }
      }, name)
    }, {
      field: 'title',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnTitleName",
        defaultMessage: "Title",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 247,
          columnNumber: 11
        }
      })
    }, {
      field: 'type',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnTypeName",
        defaultMessage: "Type",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 11
        }
      })
    }, {
      field: 'required',
      width: '70px',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnRequiredName",
        defaultMessage: "Required",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 11
        }
      })
    }, {
      field: 'multi',
      width: '70px',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.packageDetails.apiReference.columnMultidName",
        defaultMessage: "Multi",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 276,
          columnNumber: 11
        }
      })
    }];
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h6", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.packageDetails.apiReference.variableTableTitle",
    defaultMessage: "Variables",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: vars,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 7
    }
  }));
};