"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationDebugger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _icons = require("../../../../../services/icons");
var _hooks = require("../../../hooks");
var _ = require("..");
var _services = require("../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/debug/components/integration_debugger.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchInstalledIntegrations = async () => {
  var _response$data;
  const response = await (0, _hooks.sendGetPackages)({
    prerelease: true
  });
  if (response.error) {
    throw new Error(response.error.message);
  }
  const installedIntegrations = (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.items.filter(({
    status
  }) => status === 'installed');
  return installedIntegrations;
};
const IntegrationDebugger = () => {
  var _integrations$data$ma, _integrations$data, _integrations$data2, _selectedOptions$0$ic, _selectedOptions$;
  const {
    http,
    notifications
  } = (0, _hooks.useStartServices)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const [selectedIntegrationId, setSelectedIntegrationId] = (0, _react.useState)();
  const [isReinstallModalVisible, setIsReinstallModalVisible] = (0, _react.useState)(false);
  const [isUninstallModalVisible, setIsUninstallModalVisible] = (0, _react.useState)(false);
  const integrations = (0, _reactQuery.useQuery)(['debug-integrations'], fetchInstalledIntegrations);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const uninstallMutation = (0, _reactQuery.useMutation)(async integration => {
    const response = await (0, _hooks.sendRemovePackage)({
      pkgName: integration.name,
      pkgVersion: integration.version
    }, {
      force: true
    });
    if (response.error) {
      notifications.toasts.addError(response.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.uninstall.error', {
          defaultMessage: 'Error uninstalling {integrationTitle}',
          values: {
            integrationTitle: integration.title
          }
        }),
        toastMessage: response.error.message
      });
      setIsUninstallModalVisible(false);
      throw new Error(response.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.uninstall.success', {
      defaultMessage: 'Successfully uninstalled {integrationTitle}',
      values: {
        integrationTitle: integration.title
      }
    }));
    setSelectedIntegrationId(undefined);
    setIsUninstallModalVisible(false);
    _.queryClient.invalidateQueries(['debug-integrations']);
    return response.data;
  });
  const reinstallMutation = (0, _reactQuery.useMutation)(async integration => {
    const uninstallResponse = await (0, _hooks.sendRemovePackage)({
      pkgName: integration.name,
      pkgVersion: integration.version
    }, {
      force: true
    });
    if (uninstallResponse.error) {
      notifications.toasts.addError(uninstallResponse.error, {
        title: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.reinstall.error', {
          defaultMessage: 'Error reinstalling {integrationTitle}',
          values: {
            integrationTitle: integration.title
          }
        }),
        toastMessage: uninstallResponse.error.message
      });
      setIsReinstallModalVisible(false);
      throw new Error(uninstallResponse.error.message);
    }
    const installResponse = await (0, _hooks.sendInstallPackage)(integration.name, integration.version);
    if (installResponse.error) {
      notifications.toasts.addError(new Error(installResponse.error.message), {
        title: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.reinstall.error', {
          defaultMessage: 'Error reinstalling {integrationTitle}',
          values: {
            integrationTitle: integration.title
          }
        }),
        toastMessage: installResponse.error.message
      });
      setIsReinstallModalVisible(false);
      throw new Error(installResponse.error.message);
    }
    notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.reinstall.success', {
      defaultMessage: 'Successfully reinstalled {integrationTitle}',
      values: {
        integrationTitle: integration.title
      }
    }));
    setSelectedIntegrationId(undefined);
    setIsReinstallModalVisible(false);
    _.queryClient.invalidateQueries(['debug-integrations']);
    return installResponse.data;
  });
  if (integrations.status === 'error') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: "Error",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.debug.integrationDebugger.fetchError",
      defaultMessage: "Error fetching installed Integrations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 9
      }
    }));
  }
  const comboBoxOptions = (_integrations$data$ma = (_integrations$data = integrations.data) === null || _integrations$data === void 0 ? void 0 : _integrations$data.map(integration => ({
    label: integration.name,
    value: integration.id,
    icon: (0, _icons.getEuiIconType)(integration, http.basePath)
  }))) !== null && _integrations$data$ma !== void 0 ? _integrations$data$ma : [];
  const selectedOptions = selectedIntegrationId ? [comboBoxOptions.find(option => option.value === selectedIntegrationId)] : [];
  const selectedIntegration = (_integrations$data2 = integrations.data) === null || _integrations$data2 === void 0 ? void 0 : _integrations$data2.find(integration => integration.id === selectedIntegrationId);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.description",
    defaultMessage: "Use this tool to uninstall or reinstall installed integrations.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.reinstallationDescription",
    defaultMessage: "Reinstalling an integration will uninstall and then immediately install it again. This can be useful in restoring broken or malformed integration installations when a user hasn't done much customization.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: `
            min-width: 600px;
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.selectLabel', {
      defaultMessage: 'Select an Integration'
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.selectLabel', {
      defaultMessage: 'Select an Integration'
    }),
    fullWidth: true,
    options: comboBoxOptions,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedOptions,
    isDisabled: integrations.status === 'loading',
    prepend: selectedOptions.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: (_selectedOptions$0$ic = (_selectedOptions$ = selectedOptions[0]) === null || _selectedOptions$ === void 0 ? void 0 : _selectedOptions$.icon) !== null && _selectedOptions$0$ic !== void 0 ? _selectedOptions$0$ic : 'fleetApp',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 19
      }
    })) : undefined,
    renderOption: (option, searchValue, contentClassName) => /*#__PURE__*/_react.default.createElement("span", {
      className: contentClassName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: option.icon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 17
      }
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 17
      }
    }, option.label)),
    onChange: newSelectedOptions => {
      // Handle "clear" action
      if (!newSelectedOptions.length) {
        setSelectedIntegrationId(undefined);
      } else {
        setSelectedIntegrationId(newSelectedOptions[0].value);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  })), selectedIntegration && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: () => setIsReinstallModalVisible(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 15
    }
  }, "Reinstall")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: () => setIsUninstallModalVisible(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 15
    }
  }, "Uninstall")), isReinstallModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: `Reinstall ${selectedIntegration.title}`,
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => setIsReinstallModalVisible(false),
    onConfirm: () => reinstallMutation.mutate(selectedIntegration),
    isLoading: reinstallMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.cancelReinstall', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.confirmReinstall', {
      defaultMessage: 'Reinstall'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.reinstallModal",
    defaultMessage: "Are you sure you want to reinstall {integrationTitle}?",
    values: {
      integrationTitle: selectedIntegration.title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 17
    }
  })), isUninstallModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: `Uninstall ${selectedIntegration.title}`,
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => setIsUninstallModalVisible(false),
    onConfirm: () => uninstallMutation.mutate(selectedIntegration),
    isLoading: uninstallMutation.isLoading,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.cancelUninstall', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.fleet.debug.integrationDebugger.confirmUninstall', {
      defaultMessage: 'Uninstall'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.uninstallModal",
    defaultMessage: "Are you sure you want to uninstall {integrationTitle}?",
    values: {
      integrationTitle: selectedIntegration.title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 17
    }
  })))), selectedIntegration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: getHref('integration_details_overview', {
      pkgkey: (0, _services.pkgKeyFromPackageInfo)({
        name: selectedIntegration.name,
        version: selectedIntegration.version
      })
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.debug.integrationDebugger.viewIntegrationLink",
    defaultMessage: "View integration settings in Integrations UI",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 13
    }
  }))));
};
exports.IntegrationDebugger = IntegrationDebugger;