"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLastSeenInactiveAgentsCount = void 0;
var _react = require("react");
var _hooks = require("../../../../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_KEY = 'fleet.lastSeenInactiveAgentsCount';
const useLastSeenInactiveAgentsCount = () => {
  const {
    storage
  } = (0, _hooks.useStartServices)();
  const [lastSeenInactiveAgentsCount, setLastSeenInactiveAgentsCount] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    const storageValue = storage.get(LOCAL_STORAGE_KEY);
    if (storageValue) {
      setLastSeenInactiveAgentsCount(parseInt(storageValue, 10));
    }
  }, [storage]);
  const updateLastSeenInactiveAgentsCount = inactiveAgents => {
    storage.set(LOCAL_STORAGE_KEY, inactiveAgents.toString());
    setLastSeenInactiveAgentsCount(inactiveAgents);
  };
  return [lastSeenInactiveAgentsCount, updateLastSeenInactiveAgentsCount];
};
exports.useLastSeenInactiveAgentsCount = useLastSeenInactiveAgentsCount;