"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildConstantsDefinitions = exports.TIME_SYSTEM_PARAMS = void 0;
exports.getCompatibleLiterals = getCompatibleLiterals;
exports.getDateLiterals = getDateLiterals;
exports.getTimeUnitLiterals = getTimeUnitLiterals;
exports.getUnitDuration = getUnitDuration;
var _esqlTypes = require("@kbn/esql-types");
var _i18n = require("@kbn/i18n");
var _helpers = require("./autocomplete/helpers");
var _constants = require("../constants");
var _complete_items = require("../../commands_registry/complete_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const TIME_SYSTEM_PARAMS = exports.TIME_SYSTEM_PARAMS = ['?_tstart', '?_tend'];

// Targeted: define option interfaces for constants/date literals

const buildConstantsDefinitions = (userConstants, detail, sortText, options, documentationValue) => userConstants.map(label => {
  const suggestion = {
    label,
    text: label + (options !== null && options !== void 0 && options.addComma ? ',' : '') + (options !== null && options !== void 0 && options.advanceCursorAndOpenSuggestions ? ' ' : ''),
    kind: 'Constant',
    detail: detail !== null && detail !== void 0 ? detail : _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.constantDefinition', {
      defaultMessage: `Constant`
    }),
    ...(documentationValue ? {
      documentation: {
        value: documentationValue
      }
    } : {}),
    sortText: sortText !== null && sortText !== void 0 ? sortText : 'A'
  };
  return options !== null && options !== void 0 && options.advanceCursorAndOpenSuggestions ? (0, _helpers.withAutoSuggest)(suggestion) : suggestion;
});
exports.buildConstantsDefinitions = buildConstantsDefinitions;
function getDateLiterals(options) {
  return [...buildConstantsDefinitions(TIME_SYSTEM_PARAMS, _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.namedParamDefinition', {
    defaultMessage: 'Bind to time filter'
  }), '1A', options,
  // appears when the user opens the second level popover
  _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.timeNamedParamDoc', {
    defaultMessage: `Use the \`?_tstart\` and \`?_tend\` parameters to bind a custom timestamp field to Kibana's time filter.`
  })), {
    label: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.chooseFromTimePickerLabel', {
      defaultMessage: 'Choose from the time picker'
    }),
    text: '',
    kind: 'Issue',
    detail: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.chooseFromTimePicker', {
      defaultMessage: 'Click to choose'
    }),
    sortText: '1A',
    command: {
      id: 'esql.timepicker.choose',
      title: _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.chooseFromTimePicker', {
        defaultMessage: 'Click to choose'
      })
    }
  }];
}
function getUnitDuration(unit = 1) {
  const filteredTimeLiteral = _constants.timeUnitsToSuggest.filter(({
    name
  }) => {
    const result = /s$/.test(name);
    return unit > 1 ? result : !result;
  });
  return filteredTimeLiteral.map(({
    name
  }) => `${unit} ${name}`);
}

/**
 * Returns time unit literals (e.g., "1 day", "1 hour") and optionally appends a trailing comma item.
 * Generic literal builder (no policy), controlled via options.
 */
function getTimeUnitLiterals(addComma, advanceCursorAndOpenSuggestions) {
  const items = [...buildConstantsDefinitions(_constants.timeUnitsToSuggest.map(({
    name
  }) => name), undefined, undefined, {
    addComma,
    advanceCursorAndOpenSuggestions
  })];
  if (addComma || advanceCursorAndOpenSuggestions) {
    items.push(_complete_items.commaCompleteItem);
  }
  return items;
}

/**
 * Given information about the current parameter type, suggest
 * some literals that may make sense.
 */
function getCompatibleLiterals(types, options, variables) {
  const suggestions = [];
  if (types.includes('time_duration')) {
    // TODO distinction between date_period and time durations!
    const timeLiteralSuggestions = [...buildConstantsDefinitions(getUnitDuration(1), undefined, undefined, options)];
    if (options !== null && options !== void 0 && options.supportsControls) {
      var _variables$filter;
      const userDefinedColumns = (_variables$filter = variables === null || variables === void 0 ? void 0 : variables.filter(variable => variable.type === _esqlTypes.ESQLVariableType.TIME_LITERAL)) !== null && _variables$filter !== void 0 ? _variables$filter : [];
      timeLiteralSuggestions.push(...(0, _helpers.getControlSuggestion)(_esqlTypes.ESQLVariableType.TIME_LITERAL, userDefinedColumns.map(v => `?${v.key}`)));
    }
    // filter plural for now and suggest only unit + singular
    suggestions.push(...timeLiteralSuggestions); // i.e. 1 year
  }
  if (types.includes('date')) {
    suggestions.push(...getDateLiterals({
      addComma: options === null || options === void 0 ? void 0 : options.addComma,
      advanceCursorAndOpenSuggestions: options === null || options === void 0 ? void 0 : options.advanceCursorAndOpenSuggestions
    }));
  }
  return suggestions;
}