"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _walker = require("../../../walker");
var _validation = require("../../../definitions/utils/validation");
var _utils = require("../../../definitions/utils");
var _is = require("../../../ast/is");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const validate = (command, ast, context, callbacks) => {
  const messages = [];
  messages.push(...(0, _validation.validateCommandArguments)(command, ast, context, callbacks));
  const allCommands = _walker.Walker.commands(ast);
  const fromCommands = allCommands.filter(({
    name
  }) => name.toLowerCase() === 'from');
  const hasSubqueries = fromCommands.some(cmd => cmd.args.some(arg => (0, _is.isSubQuery)(arg)));
  const isInsideSubquery = !ast.some(cmd => cmd.location === command.location);
  if (hasSubqueries && !isInsideSubquery) {
    messages.push(_utils.errors.inlineStatsNotAllowedAfterLimit(command));
  }
  return messages;
};
exports.validate = validate;