"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIndicesFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../common/types/api");
var _is_not_nullish = require("../../../../../common/utils/is_not_nullish");
var _handle_api_errors = require("../../../shared/flash_messages/handle_api_errors");
var _indices_select_combobox = require("../search_applications/components/indices_select_combobox");
var _add_indices_logic = require("./add_indices_logic");
var _search_application_view_logic = require("./search_application_view_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/applications/components/search_application/add_indices_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddIndicesFlyout = ({
  onClose
}) => {
  var _searchApplicationDat;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    searchApplicationData
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    selectedIndices,
    updateSearchApplicationStatus,
    updateSearchApplicationError
  } = (0, _kea.useValues)(_add_indices_logic.AddIndicesLogic);
  const {
    setSelectedIndices,
    submitSelectedIndices
  } = (0, _kea.useActions)(_add_indices_logic.AddIndicesLogic);
  const existingIndices = searchApplicationData === null || searchApplicationData === void 0 ? void 0 : (_searchApplicationDat = searchApplicationData.indices) === null || _searchApplicationDat === void 0 ? void 0 : _searchApplicationDat.map(index => index.name);
  const selectedOptions = (0, _react.useMemo)(() => selectedIndices.map(index => (0, _indices_select_combobox.indexToOption)(index)), [selectedIndices]);
  const onIndicesChange = (0, _react.useCallback)(options => {
    setSelectedIndices(options.map(({
      label
    }) => label).filter(_is_not_nullish.isNotNullish));
  }, [setSelectedIndices]);
  const [isIndicesSelectComboBoxDisabled, setIndicesSelectComboBoxDisabled] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.title', {
    defaultMessage: 'Add new indices'
  }))), updateSearchApplicationStatus === _api.Status.ERROR && updateSearchApplicationError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.updateError.title', {
      defaultMessage: 'Error updating search application'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, (0, _handle_api_errors.getErrorsFromHttpResponse)(updateSearchApplicationError).map((errMessage, i) => /*#__PURE__*/_react.default.createElement("p", {
    id: `createErrorMsg.${i}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 17
    }
  }, errMessage))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_indices_select_combobox.IndicesSelectComboBox, {
    fullWidth: true,
    onChange: onIndicesChange,
    selectedOptions: selectedOptions,
    ignoredOptions: existingIndices,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.selectableLabel', {
      defaultMessage: 'Select searchable indices'
    }),
    setIndicesSelectComboBoxDisabled: setIndicesSelectComboBoxDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "rowReverse",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchAddIndicesFlyoutAddSelectedButton",
    fill: true,
    "data-telemetry-id": "entSearchApplications-indices-addNewIndices-submit",
    iconType: "plusInCircle",
    onClick: submitSelectedIndices,
    disabled: isIndicesSelectComboBoxDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.submitButton', {
    defaultMessage: 'Add selected'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "enterpriseSearchAddIndicesFlyoutCancelButton",
    "data-telemetry-id": "entSearchApplications-indices-addNewIndices-cancel",
    flush: "left",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.cancelButton', {
    defaultMessage: 'Cancel'
  }))))));
};
exports.AddIndicesFlyout = AddIndicesFlyout;