"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTracesSummaryColumn = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _discoverContextualComponents = require("@kbn/discover-contextual-components");
var _use_discover_services = require("../../../hooks/use_discover_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/components/data_types/traces/summary_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const SummaryColumn = props => {
  const {
    share,
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  return /*#__PURE__*/_react.default.createElement(_discoverContextualComponents.LazySummaryColumn, (0, _extends2.default)({}, props, {
    share: share,
    core: core,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 10
    }
  }));
};
const getTracesSummaryColumn = params => {
  const {
    actions,
    dataView,
    density,
    rowHeight
  } = params;
  const shouldShowFieldHandler = createGetShouldShowFieldHandler(dataView);
  return props => /*#__PURE__*/_react.default.createElement(SummaryColumn, (0, _extends2.default)({}, props, {
    isTracesSummary: true,
    density: density,
    onFilter: actions.addFilter,
    rowHeight: rowHeight,
    shouldShowFieldHandler: shouldShowFieldHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }));
};
exports.getTracesSummaryColumn = getTracesSummaryColumn;
const createGetShouldShowFieldHandler = dataView => {
  const dataViewFields = dataView.fields.getAll().map(fld => fld.name);
  return (0, _discoverUtils.getShouldShowFieldHandler)(dataViewFields, dataView, true);
};