"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertUtils = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _esqlUtils = require("@kbn/esql-utils");
var _common = require("@kbn/data-plugin/common");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/view_alert/view_alert_utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const BASE_ALERTING_API_PATH = '/api/alerting';
const buildTimeRangeFilter = (dataView, fetchedAlert, timeFieldName) => {
  const filter = (0, _common.getTime)(dataView, {
    from: `now-${fetchedAlert.params.timeWindowSize}${fetchedAlert.params.timeWindowUnit}`,
    to: 'now'
  });
  return {
    from: filter === null || filter === void 0 ? void 0 : filter.query.range[timeFieldName].gte,
    to: filter === null || filter === void 0 ? void 0 : filter.query.range[timeFieldName].lte
  };
};
const getAlertUtils = (openActualAlert, queryParams, toastNotifications, core, data, dataViews) => {
  const showDataViewFetchError = alertId => {
    const errorTitle = _i18n.i18n.translate('discover.viewAlert.dataViewErrorTitle', {
      defaultMessage: 'Error fetching data view'
    });
    const errorText = _i18n.i18n.translate('discover.viewAlert.dataViewErrorText', {
      defaultMessage: 'Data view failure of the alert rule with id {alertId}.',
      values: {
        alertId
      }
    });
    toastNotifications.addDanger({
      title: errorTitle,
      text: errorText
    });
  };
  const fetchAlert = async id => {
    try {
      return await core.http.get(`${BASE_ALERTING_API_PATH}/rule/${id}`);
    } catch (error) {
      const errorTitle = _i18n.i18n.translate('discover.viewAlert.alertRuleFetchErrorTitle', {
        defaultMessage: 'Error fetching alert rule'
      });
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
          readOnly: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 28
          }
        }, error.message), core)
      });
      throw new Error(errorTitle);
    }
  };
  const fetchSearchSource = async fetchedAlert => {
    try {
      return {
        alert: fetchedAlert,
        searchSource: await data.search.searchSource.create(fetchedAlert.params.searchConfiguration)
      };
    } catch (error) {
      const errorTitle = _i18n.i18n.translate('discover.viewAlert.searchSourceErrorTitle', {
        defaultMessage: 'Error fetching search source'
      });
      toastNotifications.addDanger({
        title: errorTitle,
        text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
          markdownContent: error.message,
          readOnly: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 109,
            columnNumber: 28
          }
        }), core)
      });
      throw new Error(errorTitle);
    }
  };
  const buildLocatorParams = async ({
    alert,
    searchSource
  }) => {
    var _dataView;
    let dataView = searchSource.getField('index');
    let query = searchSource.getField('query') || data.query.queryString.getDefaultQuery();

    // Dataview and query for ES|QL alerts
    if (alert.params && 'esqlQuery' in alert.params && alert.params.esqlQuery && 'esql' in alert.params.esqlQuery) {
      query = alert.params.esqlQuery;
      const indexPattern = (0, _esqlUtils.getIndexPatternFromESQLQuery)(alert.params.esqlQuery.esql);
      dataView = await dataViews.create({
        title: indexPattern,
        timeFieldName: alert.params.timeField
      });
    }
    const timeFieldName = (_dataView = dataView) === null || _dataView === void 0 ? void 0 : _dataView.timeFieldName;
    // data view fetch error
    if (!dataView || !timeFieldName) {
      showDataViewFetchError(alert.id);
      throw new Error('Data view fetch error');
    }
    const timeRange = openActualAlert ? {
      from: queryParams.from,
      to: queryParams.to
    } : buildTimeRangeFilter(dataView, alert, timeFieldName);
    return {
      query,
      dataViewSpec: dataView.toSpec(false),
      timeRange,
      filters: searchSource.getField('filter')
    };
  };
  return {
    fetchAlert,
    fetchSearchSource,
    buildLocatorParams
  };
};
exports.getAlertUtils = getAlertUtils;