"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createOpenFileUploadLiteAction = createOpenFileUploadLiteAction;
exports.createOpenFileUploadLiteTrigger = void 0;
var _i18n = require("@kbn/i18n");
var _fileUploadCommon = require("@kbn/file-upload-common");
var _create_flyout = require("./flyout/create_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createOpenFileUploadLiteTrigger = exports.createOpenFileUploadLiteTrigger = {
  id: _fileUploadCommon.OPEN_FILE_UPLOAD_LITE_TRIGGER,
  title: _i18n.i18n.translate('xpack.dataVisualizer.file.lite.actions.triggerTitle', {
    defaultMessage: 'Open file upload UI'
  }),
  description: _i18n.i18n.translate('xpack.dataVisualizer.file.lite.actions.triggerDescription', {
    defaultMessage: 'Open file upload UI'
  })
};
function createOpenFileUploadLiteAction(coreStart, plugins) {
  return {
    id: 'create-open-file-upload-lite-action',
    type: _fileUploadCommon.OPEN_FILE_UPLOAD_LITE_ACTION,
    getIconType(context) {
      return 'machineLearningApp';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.dataVisualizer.file.lite.actions.displayName', {
      defaultMessage: 'Open file upload UI'
    }),
    async execute({
      onUploadComplete,
      existingIndex,
      autoAddInference,
      autoCreateDataView,
      indexSettings,
      initialIndexName,
      flyoutContent,
      location
    }) {
      try {
        (0, _create_flyout.createFlyout)(coreStart, plugins, {
          onUploadComplete,
          existingIndex,
          autoAddInference,
          autoCreateDataView,
          indexSettings,
          initialIndexName,
          flyoutContent,
          location
        });
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible() {
      return true;
    }
  };
}