"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _fileUpload = require("@kbn/file-upload");
var _file_clash = require("./file_clash");
var _mappings = require("./mappings");
var _pipeline = require("./pipeline");
var _progress = require("./progress");
var _analysis_overrides = require("./analysis_overrides");
var _fields_stats_grid = require("../../../common/components/fields_stats_grid");
var _file_contents = require("./file_contents");
var _file_error_callouts = require("./file_error_callouts");
var _failures = require("./failures");
var _analysis_explanation = require("./analysis_explanation");
var _docs_preview = require("./docs_preview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/file_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var TAB = /*#__PURE__*/function (TAB) {
  TAB[TAB["SUMMARY"] = 0] = "SUMMARY";
  TAB[TAB["STATS"] = 1] = "STATS";
  TAB[TAB["CONTENT"] = 2] = "CONTENT";
  TAB[TAB["PREVIEW"] = 3] = "PREVIEW";
  TAB[TAB["MAPPINGS"] = 4] = "MAPPINGS";
  TAB[TAB["PIPELINE"] = 5] = "PIPELINE";
  TAB[TAB["EXPLANATION"] = 6] = "EXPLANATION";
  return TAB;
}(TAB || {});
const FileStatus = ({
  lite,
  index,
  showFileContentPreview,
  showOverrideButton = false
}) => {
  var _uploadStatus$fileCla;
  const {
    deleteFile,
    uploadStatus,
    filesStatus,
    fileUploadManager,
    pipelines,
    uploadStarted
  } = (0, _fileUpload.useFileUploadContext)();
  const fileStatus = filesStatus[index];
  const fileClash = (_uploadStatus$fileCla = uploadStatus.fileClashes[index]) !== null && _uploadStatus$fileCla !== void 0 ? _uploadStatus$fileCla : {
    clash: false
  };
  const [selectedTab, setSelectedTab] = (0, _react.useState)(TAB.PREVIEW);
  const [expanded, setExpanded] = (0, _react.useState)(false);
  const buttonCss = (0, _react2.css)`
    &:hover {
      text-decoration: none;
    }
  `;
  (0, _react.useEffect)(() => {
    if (fileStatus.analysisError !== undefined || fileStatus.fileTooLarge || filesStatus.length === 1 && fileStatus.results !== null) {
      setExpanded(true);
    }
  }, [fileStatus, filesStatus.length]);
  const showResults = fileStatus.results !== null && fileStatus.analysisError === undefined && fileStatus.fileTooLarge === false;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, uploadStarted ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_progress.UploadProgress, {
    fileStatus: fileStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }), fileStatus.failures.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_failures.Failures, {
    docCount: fileStatus.docCount,
    failedDocs: fileStatus.failures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  })) : null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fileStatus.results === null && fileStatus.analysisError === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "accordion1",
    isDisabled: fileStatus.results === null && fileStatus.analysisError === undefined,
    forceState: expanded ? 'open' : 'closed',
    onToggle: () => setExpanded(!expanded),
    buttonProps: {
      css: buttonCss
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      css: {
        fontWeight: 'bold'
      },
      "data-test-subj": `dataVisualizerFileResultsTitle-${index}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 25
      }
    }, fileStatus.fileName)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 25
      }
    }, fileStatus.fileSizeInfo.fileSizeFormatted)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_file_clash.FileClashIcon, {
      fileClash: fileClash,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 25
      }
    }))))),
    extraAction: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 19
      }
    }, fileStatus.results !== null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.fileStatus.analysisExplanationTooltip",
        defaultMessage: "Analysis explanation",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 31
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 27
      }
    }, /*#__PURE__*/_react.default.createElement(_analysis_explanation.AnalysisExplanation, {
      fileStatus: fileStatus,
      index: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 29
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_analysis_overrides.AnalysisOverrides, {
      fileStatus: fileStatus,
      analyzeFileWithOverrides: fileUploadManager.analyzeFileWithOverrides(index),
      index: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 27
      }
    }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.fileStatus.deleteFile",
        defaultMessage: "Remove file",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 27
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: () => deleteFile(index),
      iconType: "trash",
      size: "xs",
      color: "danger",
      "data-test-subj": `mlFileUploadDeleteFileButton-${index}`,
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.file.fileStatus.deleteFile', {
        defaultMessage: 'Remove file'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 25
      }
    }))))),
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, showResults ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_file_clash.FileClashResult, {
    fileClash: fileClash,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 19
    }
  }, lite && showFileContentPreview || lite === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.PREVIEW,
    onClick: () => setSelectedTab(TAB.PREVIEW),
    "data-test-subj": `mlFileUploadFileStatusPreviewTab-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.previewTabTitle",
    defaultMessage: "Preview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 25
    }
  })) : null, lite === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.STATS,
    onClick: () => setSelectedTab(TAB.STATS),
    "data-test-subj": `mlFileUploadFileStatusStatsTab-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.statsTabTitle",
    defaultMessage: "Field statistics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 25
    }
  })) : null, lite === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.MAPPINGS,
    onClick: () => setSelectedTab(TAB.MAPPINGS),
    "data-test-subj": `mlFileUploadFileStatusMappingsTab-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.mappingsTabTitle",
    defaultMessage: "Mappings",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 25
    }
  })) : null, lite === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.PIPELINE,
    onClick: () => setSelectedTab(TAB.PIPELINE),
    "data-test-subj": `mlFileUploadFileStatusPipelineTab-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileStatus.pipelineTabTitle",
    defaultMessage: "Pipeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 25
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 19
    }
  }), selectedTab === TAB.PREVIEW ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fileStatus.sampleDocs.length ? /*#__PURE__*/_react.default.createElement(_docs_preview.ResultsPreview, {
    sampleDocs: fileStatus.sampleDocs,
    mappings: fileStatus.results.mappings,
    index: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 25
    }
  }) : /*#__PURE__*/_react.default.createElement(_file_contents.FileContents, {
    fileContents: fileStatus.fileContents,
    results: fileStatus.results,
    showTitle: false,
    index: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 25
    }
  })) : null, selectedTab === TAB.STATS ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `dataVisualizerFileStatsPanel-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_fields_stats_grid.FieldsStatsGrid, {
    results: fileStatus.results,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 23
    }
  })) : null, selectedTab === TAB.MAPPINGS ? /*#__PURE__*/_react.default.createElement(_mappings.Mappings, {
    mappings: fileStatus.results.mappings,
    showTitle: false,
    readonly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 21
    }
  }) : null, selectedTab === TAB.PIPELINE && pipelines[index] !== undefined ? /*#__PURE__*/_react.default.createElement(_pipeline.IngestPipeline, {
    pipeline: pipelines[index],
    showTitle: false,
    setPipeline: fileUploadManager.updatePipeline(index),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 21
    }
  }) : null) : null, fileStatus.analysisError ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_file_error_callouts.FileCouldNotBeRead, {
    error: fileStatus.analysisError,
    loaded: false,
    showEditFlyout: () => {},
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 19
    }
  }), showOverrideButton ? /*#__PURE__*/_react.default.createElement(_analysis_overrides.AnalysisOverrides, {
    fileStatus: fileStatus,
    analyzeFileWithOverrides: fileUploadManager.analyzeFileWithOverrides(index),
    index: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 21
    }
  }) : null) : null, fileStatus.fileTooLarge ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_file_error_callouts.FileTooLarge, {
    fileStatus: fileStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 19
    }
  }), ' ') : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 7
    }
  }));
};
exports.FileStatus = FileStatus;