"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileContents = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _i18n = require("@kbn/i18n");
var _fileUploadCommon = require("@kbn/file-upload-common");
var _json_editor = require("../json_editor");
var _use_text_parser = require("./use_text_parser");
var _grok_highlighter = require("./grok_highlighter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/file_contents/file_contents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function semiStructureTextDataGuard(semiStructureTextData) {
  return semiStructureTextData !== null && semiStructureTextData.grokPattern !== undefined && semiStructureTextData.multilineStartPattern !== undefined;
}
const FileContents = ({
  fileContents,
  results,
  showTitle = true,
  disableHighlighting = false,
  index
}) => {
  let mode = _json_editor.EDITOR_MODE.TEXT;
  const format = results.format;
  const numberOfLines = results.num_lines_analyzed;
  if (format === _json_editor.EDITOR_MODE.JSON) {
    mode = _json_editor.EDITOR_MODE.JSON;
  }
  const isMounted = (0, _useMountedState.default)();
  const grokHighlighter = (0, _use_text_parser.useGrokHighlighter)();
  const semiStructureTextData = (0, _react.useMemo)(() => results.format === _fileUploadCommon.FILE_FORMATS.SEMI_STRUCTURED_TEXT ? {
    grokPattern: results.grok_pattern,
    multilineStartPattern: results.multiline_start_pattern,
    sampleStart: results.sample_start,
    excludeLinesPattern: results.exclude_lines_pattern,
    mappings: results.mappings,
    ecsCompatibility: results.ecs_compatibility
  } : null, [results]);
  const [isSemiStructureTextData, setIsSemiStructureTextData] = (0, _react.useState)(disableHighlighting === false && semiStructureTextDataGuard(semiStructureTextData));
  const formattedData = (0, _react.useMemo)(() => limitByNumberOfLines(fileContents, numberOfLines), [fileContents, numberOfLines]);
  const [highlightedLines, setHighlightedLines] = (0, _react.useState)(null);
  const [showHighlights, setShowHighlights] = (0, _react.useState)(isSemiStructureTextData);
  (0, _react.useEffect)(() => {
    if (isSemiStructureTextData === false || semiStructureTextData === null) {
      return;
    }
    const {
      grokPattern,
      multilineStartPattern,
      excludeLinesPattern,
      mappings,
      ecsCompatibility
    } = semiStructureTextData;
    grokHighlighter(fileContents, grokPattern, mappings, ecsCompatibility, multilineStartPattern, excludeLinesPattern).then(docs => {
      if (isMounted()) {
        setHighlightedLines(docs);
      }
    }).catch(e => {
      if (isMounted()) {
        setHighlightedLines(null);
        setIsSemiStructureTextData(false);
      }
    });
  }, [fileContents, semiStructureTextData, grokHighlighter, isSemiStructureTextData, isMounted]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `dataVisualizerFileContentsPanel-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, showTitle ? /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileContents.fileContentsTitle",
    defaultMessage: "File contents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 17
    }
  }))) : null), isSemiStructureTextData ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "dataVisualizerFileContentsHighlightingSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.dataVisualizer.file.fileContents.highlightSwitch', {
      defaultMessage: 'Grok pattern highlighting'
    }),
    compressed: true,
    checked: showHighlights,
    onChange: () => setShowHighlights(!showHighlights),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  })) : null), /*#__PURE__*/_react.default.createElement(PreviewLimitMessage, {
    wrapInCallout: showTitle === false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 7
    }
  }, format === _fileUploadCommon.FILE_FORMATS.TIKA ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileContents.characterCount",
    defaultMessage: "Preview limited to the first {numberOfChars} characters",
    values: {
      numberOfChars: _fileUploadCommon.TIKA_PREVIEW_CHARS
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileContents.firstLinesDescription",
    defaultMessage: "First {numberOfLines, plural, zero {# line} one {# line} other {# lines}}",
    values: {
      numberOfLines: showHighlights ? _grok_highlighter.LINE_LIMIT : numberOfLines
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `dataVisualizerFileContents-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, highlightedLines === null || showHighlights === false ? /*#__PURE__*/_react.default.createElement(_json_editor.JsonEditor, {
    mode: mode,
    readOnly: true,
    value: formattedData,
    height: "200px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, highlightedLines.map((line, i) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: `line-${i}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }, line, i === highlightedLines.length - 1 ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 61
    }
  }))))));
};
exports.FileContents = FileContents;
const PreviewLimitMessage = ({
  wrapInCallout = false,
  children
}) => {
  return wrapInCallout ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    size: "s",
    color: "primary",
    title: children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }), children);
};
function limitByNumberOfLines(data, numberOfLines) {
  return data.split('\n').slice(0, numberOfLines).join('\n');
}