"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactField = require("@kbn/react-field");
var _i18n = require("@kbn/i18n");
var _get_field_names = require("../../../../common/components/fields_stats_grid/get_field_names");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_status/file_contents/field_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FieldBadge = ({
  type,
  value,
  name
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiColorLightestShade = euiTheme.colors.lightestShade;
  const euiColorLightShade = euiTheme.colors.lightShade;
  const supportedType = (0, _get_field_names.getSupportedFieldType)(type !== null && type !== void 0 ? type : 'unknown');
  const tooltip = type ? _i18n.i18n.translate('xpack.dataVisualizer.file.fileContents.fieldBadge.tooltip', {
    defaultMessage: 'Type: {type}',
    values: {
      type: supportedType
    }
  }) : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: name,
    content: tooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "dataVisualizerFieldBadge",
    tabIndex: 0,
    css: {
      // magic numbers to align the badges with the text
      // and to align the icon correctly inside the badge.
      marginRight: '2px',
      marginTop: '-4px',
      padding: '0px 4px',
      cursor: 'pointer',
      pointerEvents: 'none',
      border: `1px solid ${euiColorLightShade}`,
      backgroundColor: euiColorLightestShade
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    type: supportedType,
    css: {
      marginRight: '4px',
      marginTop: '1px',
      border: `1px solid ${euiColorLightShade}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, value))));
};
exports.FieldBadge = FieldBadge;