"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatSelectEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _fieldTypes = require("@kbn/field-types");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _format_editor = require("./format_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/field_format_editor/field_format_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getFieldTypeFormatsList = (fieldType, defaultFieldFormat, fieldFormats) => {
  const formatsByType = fieldFormats.getByFieldType(fieldType).map(({
    id,
    title
  }) => ({
    id,
    title
  }));
  return [{
    id: '',
    defaultFieldFormat,
    title: _i18n.i18n.translate('indexPatternFieldEditor.defaultFormatDropDown', {
      defaultMessage: '- Default -'
    })
  }, ...formatsByType];
};
class FormatSelectEditor extends _react.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onFormatChange", (formatId, params) => this.props.onChange(formatId ? {
      id: formatId,
      params: params || {}
    } : undefined));
    (0, _defineProperty2.default)(this, "onFormatParamsChange", newParams => {
      const {
        fieldFormatId
      } = this.state;
      this.onFormatChange(fieldFormatId, newParams);
    });
    const {
      fieldFormats,
      esTypes
    } = props;
    const kbnType = (0, _fieldTypes.castEsToKbnFieldTypeName)(esTypes[0] || 'keyword');
    this.state = {
      fieldTypeFormats: getFieldTypeFormatsList(kbnType, fieldFormats.getDefaultType(kbnType, esTypes), fieldFormats),
      kbnType
    };
  }
  render() {
    const {
      fieldFormatEditors,
      onError,
      value,
      fieldFormats,
      esTypes,
      disabled
    } = this.props;
    const fieldFormatId = value === null || value === void 0 ? void 0 : value.id;
    const {
      kbnType
    } = this.state;
    const {
      fieldTypeFormats
    } = this.state;
    const defaultFormat = fieldTypeFormats[0].defaultFieldFormat.title;

    // get current formatter for field, provides default if none exists
    const format = value !== null && value !== void 0 && value.id ? fieldFormats.getInstance(value === null || value === void 0 ? void 0 : value.id, value === null || value === void 0 ? void 0 : value.params) : fieldFormats.getDefaultInstance(kbnType, esTypes);
    const fieldFormatParams = format.params();
    const label = defaultFormat ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.defaultFormatHeader",
      defaultMessage: "Format (Default: {defaultFormat})",
      values: {
        defaultFormat: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 128,
            columnNumber: 26
          }
        }, defaultFormat)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternFieldEditor.formatHeader",
      defaultMessage: "Format",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: label,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      value: fieldFormatId || '',
      options: fieldTypeFormats.map(fmt => {
        return {
          value: fmt.id || '',
          text: fmt.title
        };
      }),
      "data-test-subj": "editorSelectedFormatId",
      onChange: e => {
        this.onFormatChange(e.target.value);
      },
      disabled: disabled,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    })), fieldFormatId ? /*#__PURE__*/_react.default.createElement(_format_editor.FormatEditor, {
      fieldType: kbnType,
      fieldFormat: format,
      fieldFormatId: fieldFormatId,
      fieldFormatParams: fieldFormatParams,
      fieldFormatEditors: fieldFormatEditors,
      onChange: params => {
        this.onFormatChange(fieldFormatId, params);
      },
      onError: onError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 11
      }
    }) : null);
  }
}
exports.FormatSelectEditor = FormatSelectEditor;