"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nameColumn = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _react2 = require("@emotion/react");
var _common = require("../../../../../../../common");
var _ = require("../..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/components/table/columns/name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function isSessionRestorable(status) {
  return status === _common.SearchSessionStatus.IN_PROGRESS || status === _common.SearchSessionStatus.COMPLETE;
}
const NameColumnText = ({
  status,
  children,
  href,
  onClick
}) => {
  const hideLink = status === _common.SearchSessionStatus.IN_PROGRESS;
  if (hideLink) return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "sessionManagementNameText",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }, children);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, {
      href: href,
      onClick: onClick,
      "data-test-subj": "sessionManagementNameLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 5
      }
    }, children)
  );
};
const nameColumn = ({
  core,
  searchUsageCollector,
  kibanaVersion,
  onBackgroundSearchOpened
}) => ({
  field: 'name',
  name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerName', {
    defaultMessage: 'Name'
  }),
  sortable: true,
  render: (name, session) => {
    const {
      restoreUrl,
      reloadUrl,
      status,
      version
    } = session;
    const isRestorable = isSessionRestorable(status);
    const href = isRestorable ? restoreUrl : reloadUrl;
    const trackAction = isRestorable ? searchUsageCollector.trackSessionViewRestored : searchUsageCollector.trackSessionReloaded;
    const notRestorableWarning = isRestorable ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "warning",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.mgmt.searchSessions.table.notRestorableWarning",
        defaultMessage: "The background search will be executed again. You can then save it for future use.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    });

    // show version warning only if:
    // 1. the session was created in a different version of Kibana
    // AND
    // 2. if still can restore this session: it has IN_PROGRESS or COMPLETE status.
    const versionIncompatibleWarning = isRestorable && version !== kibanaVersion ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "warning",
      iconProps: {
        'data-test-subj': 'versionIncompatibleWarningTestSubj'
      },
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.mgmt.searchSessions.table.versionIncompatibleWarning",
        defaultMessage: "This background search was created in a Kibana instance running a different version. It may not restore correctly.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }) : null;
    return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: {
        application: core.application
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(NameColumnText, {
      status: status,
      href: href,
      onClick: event => {
        trackAction === null || trackAction === void 0 ? void 0 : trackAction();
        onBackgroundSearchOpened === null || onBackgroundSearchOpened === void 0 ? void 0 : onBackgroundSearchOpened({
          session,
          event
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_.TableText, {
      "data-test-subj": "sessionManagementNameCol",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 15
      }
    }, name), notRestorableWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: iconCss,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 17
      }
    }, notRestorableWarning), versionIncompatibleWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: iconCss,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, versionIncompatibleWarning)))));
  }
});
exports.nameColumn = nameColumn;
const iconCss = (0, _react2.css)`
  line-height: 1;
`;