"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scanDashboards = scanDashboards;
var _dashboard_saved_object = require("./dashboard_saved_object");
var _transforms = require("./content_management/v1/transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function scanDashboards(ctx, page, perPage) {
  const {
    core
  } = await ctx.resolve(['core']);
  const soResponse = await core.savedObjects.client.find({
    type: _dashboard_saved_object.DASHBOARD_SAVED_OBJECT_TYPE,
    fields: ['description', 'title', 'panelsJSON'],
    perPage,
    page
  });
  return {
    dashboards: soResponse.saved_objects.map(so => {
      const {
        description,
        tags,
        title,
        panels
      } = (0, _transforms.transformDashboardOut)(so.attributes, so.references);
      return {
        id: so.id,
        references: so.references,
        description,
        panels: panels !== null && panels !== void 0 ? panels : [],
        tags,
        title: title !== null && title !== void 0 ? title : ''
      };
    }),
    page: soResponse.page,
    total: soResponse.total
  };
}