"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.coreFeatureFlagsMock = void 0;
var _rxjs = require("rxjs");
var _lazyObject = require("@kbn/lazy-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createFeatureFlagsSetup = () => {
  return (0, _lazyObject.createLazyObjectFromAnnotations)({
    "getInitialFeatureFlags": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation(() => ({}))),
    "setProvider": (0, _lazyObject.annotateLazy)(() => jest.fn()),
    "appendContext": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation(Promise.resolve))
  });
};
const createFeatureFlagsStart = () => {
  return (0, _lazyObject.createLazyObjectFromAnnotations)({
    "appendContext": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation(Promise.resolve)),
    "getBooleanValue": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation((_, fallback) => fallback)),
    "getNumberValue": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation((_, fallback) => fallback)),
    "getStringValue": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation((_, fallback) => fallback)),
    "getBooleanValue$": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation((_, fallback) => (0, _rxjs.of)(fallback))),
    "getStringValue$": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation((_, fallback) => (0, _rxjs.of)(fallback))),
    "getNumberValue$": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation((_, fallback) => (0, _rxjs.of)(fallback)))
  });
};
const createFeatureFlagsServiceMock = () => {
  return (0, _lazyObject.createLazyObjectFromAnnotations)({
    "setup": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation(createFeatureFlagsSetup)),
    "start": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation(async () => createFeatureFlagsStart())),
    "stop": (0, _lazyObject.annotateLazy)(() => jest.fn().mockImplementation(Promise.resolve))
  });
};

/**
 * Mocks for the Feature Flags service (browser-side)
 */
const coreFeatureFlagsMock = exports.coreFeatureFlagsMock = {
  /**
   * Mocks the entire feature flags service
   */
  create: createFeatureFlagsServiceMock,
  /**
   * Mocks the setup contract
   */
  createSetup: createFeatureFlagsSetup,
  /**
   * Mocks the start contract
   */
  createStart: createFeatureFlagsStart
};