"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _item = require("./item");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _handle_roving_index = require("../../utils/handle_roving_index");
var _update_tab_indices = require("../../utils/update_tab_indices");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/footer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getWrapperStyles = (theme, isCollapsed) => (0, _react2.css)`
  align-items: center;
  border-top: ${theme.border.width.thin} solid ${theme.colors.borderBaseSubdued};
  display: flex;
  flex-direction: column;
  gap: ${theme.size.xs};
  justify-content: center;
  padding-top: ${isCollapsed ? theme.size.s : theme.size.m};
`;
const FooterBase = /*#__PURE__*/(0, _react.forwardRef)(({
  children,
  isCollapsed
}, ref) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleRef = node => {
    if (typeof ref === 'function') {
      ref(node);
    } else if (ref) {
      ref.current = node;
    }
    if (node) {
      const elements = (0, _get_focusable_elements.getFocusableElements)(node);
      (0, _update_tab_indices.updateTabIndices)(elements);
    }
  };
  const wrapperStyles = (0, _react.useMemo)(() => getWrapperStyles(euiTheme, isCollapsed), [euiTheme, isCollapsed]);
  return (
    /*#__PURE__*/
    // The footer itself is not interactive but the children are
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
    _react.default.createElement("footer", {
      "aria-label": _i18n.i18n.translate('core.ui.chrome.sideNavigation.footerAriaLabel', {
        defaultMessage: 'Side navigation'
      }),
      css: wrapperStyles,
      onKeyDown: _handle_roving_index.handleRovingIndex,
      ref: handleRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 5
      }
    }, children)
  );
});
const Footer = exports.Footer = Object.assign(FooterBase, {
  Item: _item.FooterItem
});