"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContentClient = exports.ContentClientProvider = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactQuery = require("@kbn/react-query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/content_management/public/content_client/content_client_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ContentClientContext = /*#__PURE__*/_react.default.createContext(null);
const useContentClient = () => {
  const contentClient = _react.default.useContext(ContentClientContext);
  if (!contentClient) throw new Error('contentClient not found');
  return contentClient;
};
exports.useContentClient = useContentClient;
const ContentClientProvider = ({
  contentClient,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(ContentClientContext.Provider, {
    value: contentClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: contentClient.queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, children));
};
exports.ContentClientProvider = ContentClientProvider;