"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableConsole = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react2 = require("@emotion/react");
var _embeddable_console = require("../../../types/embeddable_console");
var store = _interopRequireWildcard(require("../../stores/embeddable_console"));
var _load_from = require("../../lib/load_from");
var _embeddable_console3 = require("./embeddable_console.styles");
var _console_resize_button = require("./console_resize_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/embeddable/embeddable_console.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KBN_BODY_CONSOLE_CLASS = 'kbnBody--hasEmbeddableConsole';
const landmarkHeading = _i18n.i18n.translate('console.embeddableConsole.landmarkHeading', {
  defaultMessage: "Developer console. Press Enter to start editing. When you're done, press Escape to stop editing."
});
const ConsoleWrapper = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('./console_wrapper')))).ConsoleWrapper
}));
const getInitialConsoleHeight = (getConsoleHeight, euiTheme) => {
  const lastHeight = getConsoleHeight();
  if (lastHeight) {
    try {
      const value = parseInt(lastHeight, 10);
      if (!isNaN(value) && value > 0) {
        return value;
      }
    } catch {
      // ignore bad local storage value
    }
  }
  return (0, _console_resize_button.getCurrentConsoleMaxSize)(euiTheme);
};
const EmbeddableConsole = ({
  core,
  data,
  licensing,
  usageCollection,
  setDispatch,
  alternateView,
  isDevMode,
  getConsoleHeight,
  setConsoleHeight
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    setGlobalCSSVariables
  } = (0, _eui.useEuiThemeCSSVariables)();
  const chromeStyle = (0, _useObservable.default)(core.chrome.getChromeStyle$());
  const [consoleHeight, setConsoleHeightState] = (0, _react.useState)(getInitialConsoleHeight(getConsoleHeight, euiTheme));
  const [consoleState, consoleDispatch] = (0, _react.useReducer)(store.reducer, store.initialValue, value => ({
    ...value
  }));
  const isOpen = consoleState.view !== _embeddable_console.EmbeddableConsoleView.Closed;
  const styles = (0, _embeddable_console3.useStyles)();
  (0, _react.useEffect)(() => {
    setDispatch(consoleDispatch);
    return () => setDispatch(null);
  }, [setDispatch, consoleDispatch]);
  (0, _react.useEffect)(() => {
    if (consoleState.view === _embeddable_console.EmbeddableConsoleView.Console && consoleState.loadFromContent) {
      (0, _load_from.setLoadFromParameter)(consoleState.loadFromContent);
    } else if (consoleState.view === _embeddable_console.EmbeddableConsoleView.Closed) {
      (0, _load_from.removeLoadFromParameter)();
    }
  }, [consoleState.view, consoleState.loadFromContent]);
  (0, _react.useEffect)(() => {
    document.body.classList.add(KBN_BODY_CONSOLE_CLASS);
    return () => document.body.classList.remove(KBN_BODY_CONSOLE_CLASS);
  }, []);
  (0, _react.useEffect)(() => {
    setGlobalCSSVariables({
      '--embedded-console-height': `${consoleHeight}px`,
      '--embedded-console-bottom': `-${consoleHeight}px`
    });
    setConsoleHeight(consoleHeight.toString());
  }, [consoleHeight, setGlobalCSSVariables, setConsoleHeight]);
  const showConsole = consoleState.view !== _embeddable_console.EmbeddableConsoleView.Closed && (consoleState.view === _embeddable_console.EmbeddableConsoleView.Console || alternateView === undefined);
  const showAlternateView = consoleState.view === _embeddable_console.EmbeddableConsoleView.Alternate && alternateView !== undefined;
  const setIsConsoleOpen = value => {
    consoleDispatch(value ? {
      type: 'open'
    } : {
      type: 'close'
    });
  };
  const toggleConsole = () => setIsConsoleOpen(!isOpen);
  const clickAlternateViewActivateButton = e => {
    e.preventDefault();
    switch (consoleState.view) {
      case _embeddable_console.EmbeddableConsoleView.Console:
      case _embeddable_console.EmbeddableConsoleView.Closed:
        consoleDispatch({
          type: 'open',
          payload: {
            alternateView: true
          }
        });
        break;
      case _embeddable_console.EmbeddableConsoleView.Alternate:
        consoleDispatch({
          type: 'open',
          payload: {
            alternateView: false
          }
        });
        break;
    }
  };
  const onKeyDown = event => {
    if (event.key === _eui.keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      setIsConsoleOpen(false);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: styles.embeddableConsoleGlobal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    onClickOutside: toggleConsole,
    disabled: !isOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("section", {
    "aria-label": landmarkHeading,
    css: [styles.embeddableConsole, isOpen && styles.embeddableConsoleOpen, chromeStyle === 'classic' && styles.embeddableConsoleChromeClassic, chromeStyle === 'project' && styles.embeddableConsoleChromeProject, chromeStyle === undefined && styles.embeddableConsoleChromeDefault, styles.embeddableConsoleFixed],
    "data-test-subj": "consoleEmbeddedSection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }, landmarkHeading)), /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: 'dark',
    wrapperProps: {
      cloneElement: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, isOpen && /*#__PURE__*/_react.default.createElement(_console_resize_button.EmbeddedConsoleResizeButton, {
    consoleHeight: consoleHeight,
    setConsoleHeight: setConsoleHeightState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: styles.embeddableConsoleControls,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    iconType: isOpen ? 'arrowUp' : 'arrowDown',
    onClick: toggleConsole,
    css: styles.embeddableConsoleControlsButton,
    "data-test-subj": "consoleEmbeddedControlBar",
    "data-telemetry-id": "console-embedded-controlbar-button",
    "aria-label": _i18n.i18n.translate('console.embeddableConsole.toggleButtonAriaLabel', {
      defaultMessage: 'Toggle console'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('console.embeddableConsole.title', {
    defaultMessage: 'Console'
  })), alternateView && /*#__PURE__*/_react.default.createElement("div", {
    css: styles.embeddableControlsAltViewButtonContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(alternateView.ActivationButton, {
    activeView: showAlternateView,
    onClick: clickAlternateViewActivateButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 23
    }
  }))))), consoleState.consoleHasBeenOpened ? /*#__PURE__*/_react.default.createElement(ConsoleWrapper, {
    isOpen: showConsole,
    core: core,
    data: data,
    licensing: licensing,
    usageCollection: usageCollection,
    onKeyDown: onKeyDown,
    isDevMode: isDevMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 15
    }
  }) : null, showAlternateView ? /*#__PURE__*/_react.default.createElement("div", {
    css: styles.embeddableConsoleContent,
    "data-test-subj": "consoleEmbeddedBody",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(alternateView.ViewContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 17
    }
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "aria-live": "assertive",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('console.embeddableConsole.customScreenReaderAnnouncement', {
    defaultMessage: 'There is a new region landmark called {landmarkHeading} with page level controls at the end of the document.',
    values: {
      landmarkHeading
    }
  }))))));
};
exports.EmbeddableConsole = EmbeddableConsole;