"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyColors = exports.ColorPicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lighten_color = require("../../services/palettes/lighten_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/charts/public/static/components/color_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const legacyColors = exports.legacyColors = ['#3F6833', '#967302', '#2F575E', '#99440A', '#58140C', '#052B51', '#511749', '#3F2B5B', '#508642', '#CCA300', '#447EBC', '#C15C17', '#890F02', '#0A437C', '#6D1F62', '#584477', '#629E51', '#E5AC0E', '#64B0C8', '#E0752D', '#BF1B00', '#0A50A1', '#962D82', '#614D93', '#7EB26D', '#EAB839', '#6ED0E0', '#EF843C', '#E24D42', '#1F78C1', '#BA43A9', '#705DA0', '#9AC48A', '#F2C96D', '#65C5DB', '#F9934E', '#EA6460', '#5195CE', '#D683CE', '#806EB7', '#B7DBAB', '#F4D598', '#70DBED', '#F9BA8F', '#F29191', '#82B5D8', '#E5A8E2', '#AEA2E0', '#E0F9D7', '#FCEACA', '#CFFAFF', '#F9E2D2', '#FCE2DE', '#BADFF4', '#F9D9F9', '#DEDAF7'];
const euiColors = (0, _eui.euiPaletteColorBlind)({
  rotations: 4,
  order: 'group'
});
const visColorPickerColorBtnStyle = (0, _react2.css)`
  position: relative;
  input[type='radio'] {
    position: absolute;
    top: 50%;
    left: 50%;
    opacity: 0;
    transform: translate(-50%, -50%);
  }
`;
const visColorPickerValueDotStyle = (0, _react2.css)`
  cursor: pointer;
  &:hover {
    transform: scale(1.4);
  }
`;
const ColorPicker = ({
  onChange,
  color: selectedColor,
  label,
  useLegacyColors = true,
  colorIsOverwritten = true,
  onKeyDown,
  maxDepth,
  layerIndex
}) => {
  const legendColors = useLegacyColors ? legacyColors : euiColors;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const visColorPickerValueStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      width: calc(${euiTheme.size.l} * 8);
    `, [euiTheme.size.l]);
  const visColorPickerValueDotSelectedStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      border: ${euiTheme.size.xs} solid;
      border-radius: 100%;
    `, [euiTheme.size.xs]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "visColorPicker",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("fieldset", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("legend", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "charts.colorPicker.setColor.screenReaderDescription",
    defaultMessage: "Set color for value {legendDataLabel}",
    values: {
      legendDataLabel: label
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    css: visColorPickerValueStyle,
    className: "visColorPicker__value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, legendColors.map(color => /*#__PURE__*/_react.default.createElement("label", {
    key: color,
    css: visColorPickerColorBtnStyle,
    className: "visColorPicker__colorBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("input", {
    type: "radio",
    onChange: e => onChange(color, e),
    value: selectedColor,
    name: "visColorPicker__radio",
    checked: color === selectedColor,
    onKeyDown: onKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot",
    size: "l",
    color: selectedColor,
    css: [visColorPickerValueDotStyle, color === selectedColor ? visColorPickerValueDotSelectedStyle : null],
    className: "visColorPicker__valueDot",
    style: {
      color
    },
    "data-test-subj": `visColorPickerColor-${color}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }, color)))))), legendColors.some(c => c === selectedColor || layerIndex && maxDepth && (0, _lighten_color.lightenColor)(c, layerIndex, maxDepth) === selectedColor) && colorIsOverwritten && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: e => onChange(null, e),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "charts.colorPicker.clearColor",
    defaultMessage: "Reset color",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }))));
};
exports.ColorPicker = ColorPicker;