"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/actions-plugin/common");
var _kibana = require("../../common/lib/kibana");
var _use_action_types = require("../../containers/configure/use_action_types");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
var _connectors = require("./connectors");
var _closure_options = require("./closure_options");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils2 = require("../utils");
var _header_page = require("../header_page");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_breadcrumbs = require("../use_breadcrumbs");
var _navigation = require("../../common/navigation");
var _custom_fields = require("../custom_fields");
var _flyout = require("./flyout");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _use_persist_configuration = require("../../containers/configure/use_persist_configuration");
var _use_license = require("../../common/use_license");
var _templates = require("../templates");
var _form = require("../custom_fields/form");
var _form2 = require("../templates/form");
var _builder = require("../custom_fields/builder");
var _observable_types = require("../observable_types");
var _form3 = require("../observable_types/form");
var _use_cases_features = require("../../common/use_cases_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/configure_cases/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable complexity */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sectionWrapperCss = (0, _react2.css)`
  box-sizing: content-box;
  max-width: 1175px;
  width: 100%;
`;
const getFormWrapperCss = euiTheme => (0, _react2.css)`
  padding-top: ${euiTheme.size.xl};
  padding-bottom: ${euiTheme.size.xl};
  .euiFlyout {
    z-index: ${Number(euiTheme.levels.navigation) + 1};
  }
`;
const addNewCustomFieldToTemplates = ({
  templates,
  customFields
}) => {
  return templates.map(template => {
    var _template$caseFields$, _template$caseFields;
    const templateCustomFields = (_template$caseFields$ = (_template$caseFields = template.caseFields) === null || _template$caseFields === void 0 ? void 0 : _template$caseFields.customFields) !== null && _template$caseFields$ !== void 0 ? _template$caseFields$ : [];
    customFields.forEach(field => {
      if (!templateCustomFields.length || !templateCustomFields.find(templateCustomField => templateCustomField.key === field.key)) {
        var _getDefaultValue, _field$defaultValue;
        const customFieldFactory = _builder.builderMap[field.type];
        const {
          getDefaultValue
        } = customFieldFactory();
        const value = (_getDefaultValue = getDefaultValue === null || getDefaultValue === void 0 ? void 0 : getDefaultValue()) !== null && _getDefaultValue !== void 0 ? _getDefaultValue : null;
        templateCustomFields.push({
          key: field.key,
          type: field.type,
          value: (_field$defaultValue = field.defaultValue) !== null && _field$defaultValue !== void 0 ? _field$defaultValue : value
        });
      }
    });
    return {
      ...template,
      caseFields: {
        ...template.caseFields,
        customFields: [...templateCustomFields]
      }
    };
  });
};
const ConfigureCases = exports.ConfigureCases = /*#__PURE__*/_react.default.memo(() => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  (0, _use_breadcrumbs.useCasesBreadcrumbs)(_navigation.CasesDeepLinkId.casesConfigure);
  const license = (0, _use_license.useLicense)();
  const hasMinimumLicensePermissions = license.isAtLeastGold();
  const hasMinimumLicensePermissionsForObservables = license.isAtLeastPlatinum();
  const {
    isObservablesFeatureEnabled
  } = (0, _use_cases_features.useCasesFeatures)();
  const [connectorIsValid, setConnectorIsValid] = (0, _react.useState)(true);
  const [flyOutVisibility, setFlyOutVisibility] = (0, _react.useState)(null);
  const [editedConnectorItem, setEditedConnectorItem] = (0, _react.useState)(null);
  const [customFieldToEdit, setCustomFieldToEdit] = (0, _react.useState)(null);
  const [templateToEdit, setTemplateToEdit] = (0, _react.useState)(null);
  const [observableTypeToEdit, setObservableTypeToEdit] = (0, _react.useState)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data: currentConfiguration,
    isLoading: loadingCaseConfigure,
    refetch: refetchCaseConfigure
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const {
    id: configurationId,
    version: configurationVersion,
    closureType,
    connector,
    mappings,
    customFields,
    templates,
    observableTypes
  } = currentConfiguration;
  const {
    mutate: persistCaseConfigure,
    mutateAsync: persistCaseConfigureAsync,
    isLoading: isPersistingConfiguration
  } = (0, _use_persist_configuration.usePersistConfiguration)();
  const isLoadingCaseConfiguration = loadingCaseConfigure || isPersistingConfiguration;
  const {
    isLoading: isLoadingConnectors,
    data: connectors = [],
    refetch: refetchConnectors
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const {
    isLoading: isLoadingActionTypes,
    data: actionTypes = [],
    refetch: refetchActionTypes
  } = (0, _use_action_types.useGetActionTypes)();
  const onConnectorUpdated = (0, _react.useCallback)(async updatedConnector => {
    setEditedConnectorItem(updatedConnector);
    refetchConnectors();
    refetchActionTypes();
    refetchCaseConfigure();
  }, [refetchActionTypes, refetchCaseConfigure, refetchConnectors, setEditedConnectorItem]);
  const onConnectorCreated = (0, _react.useCallback)(async createdConnector => {
    const caseConnector = (0, _utils.normalizeActionConnector)(createdConnector);
    await persistCaseConfigureAsync({
      connector: caseConnector,
      closureType,
      customFields,
      templates,
      id: configurationId,
      version: configurationVersion
    });
    onConnectorUpdated(createdConnector);
  }, [persistCaseConfigureAsync, closureType, customFields, templates, configurationId, configurationVersion, onConnectorUpdated]);
  const isLoadingAny = isLoadingConnectors || isPersistingConfiguration || loadingCaseConfigure || isLoadingActionTypes;
  const updateConnectorDisabled = isLoadingAny || !connectorIsValid || connector.id === 'none';
  const onClickUpdateConnector = (0, _react.useCallback)(() => {
    setFlyOutVisibility({
      type: 'editConnector',
      visible: true
    });
  }, []);
  const onCloseAddFlyout = (0, _react.useCallback)(() => setFlyOutVisibility({
    type: 'addConnector',
    visible: false
  }), [setFlyOutVisibility]);
  const onCloseEditFlyout = (0, _react.useCallback)(() => setFlyOutVisibility({
    type: 'editConnector',
    visible: false
  }), []);
  const onAddNewConnector = (0, _react.useCallback)(() => {
    setFlyOutVisibility({
      type: 'addConnector',
      visible: true
    });
  }, []);
  const onChangeConnector = (0, _react.useCallback)(id => {
    if (id === 'add-connector') {
      setFlyOutVisibility({
        type: 'addConnector',
        visible: true
      });
      return;
    }
    const actionConnector = (0, _utils2.getConnectorById)(id, connectors);
    const caseConnector = actionConnector != null ? (0, _utils.normalizeActionConnector)(actionConnector) : (0, _utils.getNoneConnector)();
    persistCaseConfigure({
      connector: caseConnector,
      closureType,
      customFields,
      templates,
      id: configurationId,
      version: configurationVersion
    });
  }, [connectors, persistCaseConfigure, closureType, customFields, templates, configurationId, configurationVersion]);
  const onChangeClosureType = (0, _react.useCallback)(type => {
    persistCaseConfigure({
      connector,
      customFields,
      templates,
      id: configurationId,
      version: configurationVersion,
      closureType: type
    });
  }, [configurationId, configurationVersion, connector, customFields, templates, persistCaseConfigure]);
  (0, _react.useEffect)(() => {
    if (!isLoadingConnectors && connector.id !== 'none' && !connectors.some(c => c.id === connector.id)) {
      setConnectorIsValid(false);
    } else if (!isLoadingConnectors && (connector.id === 'none' || connectors.some(c => c.id === connector.id))) {
      setConnectorIsValid(true);
    }
  }, [connectors, connector, isLoadingConnectors]);
  (0, _react.useEffect)(() => {
    if (!isLoadingConnectors && connector.id !== 'none') {
      setEditedConnectorItem((0, _utils.normalizeCaseConnector)(connectors, connector));
    }
  }, [connectors, connector, isLoadingConnectors]);
  const ConnectorAddFlyout = (0, _react.useMemo)(() => (flyOutVisibility === null || flyOutVisibility === void 0 ? void 0 : flyOutVisibility.type) === 'addConnector' && flyOutVisibility !== null && flyOutVisibility !== void 0 && flyOutVisibility.visible ? triggersActionsUi.getAddConnectorFlyout({
    onClose: onCloseAddFlyout,
    featureId: _common.CasesConnectorFeatureId,
    onConnectorCreated
  }) : null,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [flyOutVisibility]);
  const ConnectorEditFlyout = (0, _react.useMemo)(() => editedConnectorItem && (flyOutVisibility === null || flyOutVisibility === void 0 ? void 0 : flyOutVisibility.type) === 'editConnector' && flyOutVisibility !== null && flyOutVisibility !== void 0 && flyOutVisibility.visible ? triggersActionsUi.getEditConnectorFlyout({
    connector: editedConnectorItem,
    onClose: onCloseEditFlyout,
    onConnectorUpdated
  }) : null,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [connector.id, editedConnectorItem, flyOutVisibility]);
  const onDeleteCustomField = (0, _react.useCallback)(key => {
    const remainingCustomFields = customFields.filter(field => field.key !== key);

    // delete the same custom field from each template as well
    const templatesWithRemainingCustomFields = templates.map(template => {
      var _template$caseFields$2, _template$caseFields2, _template$caseFields3;
      const templateCustomFields = (_template$caseFields$2 = (_template$caseFields2 = template.caseFields) === null || _template$caseFields2 === void 0 ? void 0 : (_template$caseFields3 = _template$caseFields2.customFields) === null || _template$caseFields3 === void 0 ? void 0 : _template$caseFields3.filter(field => field.key !== key)) !== null && _template$caseFields$2 !== void 0 ? _template$caseFields$2 : [];
      return {
        ...template,
        caseFields: {
          ...template.caseFields,
          customFields: [...templateCustomFields]
        }
      };
    });
    persistCaseConfigure({
      connector,
      customFields: [...remainingCustomFields],
      templates: [...templatesWithRemainingCustomFields],
      id: configurationId,
      version: configurationVersion,
      closureType
    });
  }, [closureType, configurationId, configurationVersion, connector, customFields, templates, persistCaseConfigure]);
  const onEditCustomField = (0, _react.useCallback)(key => {
    const selectedCustomField = customFields.find(item => item.key === key);
    if (selectedCustomField) {
      setCustomFieldToEdit(selectedCustomField);
    }
    setFlyOutVisibility({
      type: 'customField',
      visible: true
    });
  }, [setFlyOutVisibility, setCustomFieldToEdit, customFields]);
  const onCloseCustomFieldFlyout = (0, _react.useCallback)(() => {
    setFlyOutVisibility({
      type: 'customField',
      visible: false
    });
    setCustomFieldToEdit(null);
  }, [setFlyOutVisibility, setCustomFieldToEdit]);
  const onEditObservableType = (0, _react.useCallback)(key => {
    const selectedObservableType = observableTypes.find(item => item.key === key);
    if (selectedObservableType) {
      setObservableTypeToEdit(selectedObservableType);
    }
    setFlyOutVisibility({
      type: 'observableTypes',
      visible: true
    });
  }, [setFlyOutVisibility, observableTypes]);
  const onDeleteObservableType = (0, _react.useCallback)(key => {
    const remainingObservableTypes = observableTypes.filter(field => field.key !== key);
    persistCaseConfigure({
      connector,
      observableTypes: remainingObservableTypes,
      id: configurationId,
      version: configurationVersion,
      closureType,
      customFields,
      templates
    });
  }, [closureType, configurationId, configurationVersion, connector, observableTypes, persistCaseConfigure, customFields, templates]);
  const onCloseObservableTypesFlyout = (0, _react.useCallback)(() => {
    setFlyOutVisibility({
      type: 'observableTypes',
      visible: false
    });
    setObservableTypeToEdit(null);
  }, [setFlyOutVisibility]);
  const onObservableTypeSave = (0, _react.useCallback)(data => {
    const existingObservableIndex = observableTypes.findIndex(item => item.key === data.key);
    let updatedObservableTypes = [];
    if (existingObservableIndex === -1) {
      updatedObservableTypes = [...structuredClone(observableTypes), data];
    } else {
      updatedObservableTypes = structuredClone(observableTypes);
      updatedObservableTypes[existingObservableIndex] = data;
    }
    persistCaseConfigure({
      connector,
      id: configurationId,
      version: configurationVersion,
      closureType,
      observableTypes: updatedObservableTypes,
      customFields,
      templates
    });
    onCloseObservableTypesFlyout();
  }, [observableTypes, persistCaseConfigure, connector, configurationId, configurationVersion, closureType, customFields, templates, onCloseObservableTypesFlyout]);
  const onCustomFieldSave = (0, _react.useCallback)(data => {
    const updatedCustomFields = (0, _utils2.addOrReplaceField)(customFields, data);

    // add the new custom field to each template as well
    const updatedTemplates = addNewCustomFieldToTemplates({
      templates,
      customFields: updatedCustomFields
    });
    persistCaseConfigure({
      connector,
      customFields: updatedCustomFields,
      templates: updatedTemplates,
      id: configurationId,
      version: configurationVersion,
      closureType
    });
    setFlyOutVisibility({
      type: 'customField',
      visible: false
    });
    setCustomFieldToEdit(null);
  }, [closureType, configurationId, configurationVersion, connector, customFields, templates, persistCaseConfigure]);
  const onDeleteTemplate = (0, _react.useCallback)(key => {
    const remainingTemplates = templates.filter(field => field.key !== key);
    persistCaseConfigure({
      connector,
      customFields,
      templates: [...remainingTemplates],
      id: configurationId,
      version: configurationVersion,
      closureType
    });
  }, [closureType, configurationId, configurationVersion, connector, customFields, templates, persistCaseConfigure]);
  const onEditTemplate = (0, _react.useCallback)(key => {
    const selectedTemplate = templates.find(item => item.key === key);
    if (selectedTemplate) {
      setTemplateToEdit(selectedTemplate);
    }
    setFlyOutVisibility({
      type: 'template',
      visible: true
    });
  }, [setFlyOutVisibility, setTemplateToEdit, templates]);
  const onCloseTemplateFlyout = (0, _react.useCallback)(() => {
    setFlyOutVisibility({
      type: 'template',
      visible: false
    });
    setTemplateToEdit(null);
  }, [setFlyOutVisibility, setTemplateToEdit]);
  const onTemplateSave = (0, _react.useCallback)(data => {
    const updatedTemplates = (0, _utils2.addOrReplaceField)(templates, data);
    persistCaseConfigure({
      connector,
      customFields,
      templates: updatedTemplates,
      id: configurationId,
      version: configurationVersion,
      closureType
    });
    setFlyOutVisibility({
      type: 'template',
      visible: false
    });
    setTemplateToEdit(null);
  }, [closureType, configurationId, configurationVersion, connector, customFields, templates, persistCaseConfigure]);
  const AddOrEditCustomFieldFlyout = (flyOutVisibility === null || flyOutVisibility === void 0 ? void 0 : flyOutVisibility.type) === 'customField' && flyOutVisibility !== null && flyOutVisibility !== void 0 && flyOutVisibility.visible ? /*#__PURE__*/_react.default.createElement(_flyout.CommonFlyout, {
    isLoading: loadingCaseConfigure || isPersistingConfiguration,
    disabled: !permissions.settings || loadingCaseConfigure || isPersistingConfiguration,
    onCloseFlyout: onCloseCustomFieldFlyout,
    onSaveField: onCustomFieldSave,
    renderHeader: () => /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 578,
        columnNumber: 11
      }
    }, customFieldToEdit ? i18n.EDIT_CUSTOM_FIELD : i18n.ADD_CUSTOM_FIELD, " "),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 572,
      columnNumber: 7
    }
  }, ({
    onChange
  }) => /*#__PURE__*/_react.default.createElement(_form.CustomFieldsForm, {
    onChange: onChange,
    initialValue: customFieldToEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 582,
      columnNumber: 11
    }
  })) : null;
  const AddOrEditTemplateFlyout = (flyOutVisibility === null || flyOutVisibility === void 0 ? void 0 : flyOutVisibility.type) === 'template' && flyOutVisibility !== null && flyOutVisibility !== void 0 && flyOutVisibility.visible ? /*#__PURE__*/_react.default.createElement(_flyout.CommonFlyout, {
    isLoading: loadingCaseConfigure || isPersistingConfiguration,
    disabled: !permissions.settings || loadingCaseConfigure || isPersistingConfiguration,
    onCloseFlyout: onCloseTemplateFlyout,
    onSaveField: onTemplateSave,
    renderHeader: () => /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 595,
        columnNumber: 11
      }
    }, templateToEdit ? i18n.EDIT_TEMPLATE : i18n.CREATE_TEMPLATE),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 589,
      columnNumber: 7
    }
  }, ({
    onChange
  }) => /*#__PURE__*/_react.default.createElement(_form2.TemplateForm, {
    initialValue: templateToEdit,
    connectors: connectors !== null && connectors !== void 0 ? connectors : [],
    currentConfiguration: currentConfiguration,
    isEditMode: Boolean(templateToEdit),
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 599,
      columnNumber: 11
    }
  })) : null;
  const AddOrEditObservableTypeFlyout = (flyOutVisibility === null || flyOutVisibility === void 0 ? void 0 : flyOutVisibility.type) === 'observableTypes' && flyOutVisibility !== null && flyOutVisibility !== void 0 && flyOutVisibility.visible ? /*#__PURE__*/_react.default.createElement(_flyout.CommonFlyout, {
    isLoading: loadingCaseConfigure || isPersistingConfiguration,
    disabled: !permissions.settings || loadingCaseConfigure || isPersistingConfiguration,
    onCloseFlyout: onCloseObservableTypesFlyout,
    onSaveField: onObservableTypeSave,
    renderHeader: () => /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 618,
        columnNumber: 11
      }
    }, observableTypeToEdit ? i18n.EDIT_OBSERVABLE_TYPE : i18n.ADD_OBSERVABLE_TYPE),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 612,
      columnNumber: 7
    }
  }, ({
    onChange
  }) => /*#__PURE__*/_react.default.createElement(_form3.ObservableTypesForm, {
    onChange: onChange,
    initialValue: observableTypeToEdit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 622,
      columnNumber: 11
    }
  })) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 628,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    "data-test-subj": "case-configure-title",
    title: i18n.CONFIGURE_CASES_PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 629,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 630,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: getFormWrapperCss(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 631,
      columnNumber: 9
    }
  }, hasMinimumLicensePermissions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !connectorIsValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 636,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: i18n.WARNING_NO_CONNECTOR_TITLE,
    color: "warning",
    iconType: "question",
    "data-test-subj": "configure-cases-warning-callout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 637,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The selected connector has been deleted or you do not have the {appropriateLicense} to use it. Either select a different connector or create a new one.",
    id: "xpack.cases.configure.connectorDeletedOrLicenseWarning",
    values: {
      appropriateLicense: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/subscriptions",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 649,
          columnNumber: 29
        }
      }, i18n.LINK_APPROPRIATE_LICENSE)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 644,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 657,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 660,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_closure_options.ClosureOptions, {
    closureTypeSelected: closureType,
    disabled: isPersistingConfiguration || isLoadingConnectors || !permissions.settings,
    onChangeClosureType: onChangeClosureType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 661,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 669,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 670,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_connectors.Connectors, {
    actionTypes: actionTypes,
    connectors: connectors !== null && connectors !== void 0 ? connectors : [],
    disabled: isPersistingConfiguration || isLoadingConnectors || !permissions.settings,
    handleShowEditFlyout: onClickUpdateConnector,
    isLoading: isLoadingAny,
    mappings: mappings,
    onChangeConnector: onChangeConnector,
    selectedConnector: connector,
    updateConnectorDisabled: updateConnectorDisabled || !permissions.settings,
    onAddNewConnector: onAddNewConnector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 671,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 686,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 689,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 690,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_custom_fields.CustomFields, {
    customFields: customFields,
    isLoading: isLoadingCaseConfiguration,
    disabled: isLoadingCaseConfiguration,
    handleAddCustomField: () => setFlyOutVisibility({
      type: 'customField',
      visible: true
    }),
    handleDeleteCustomField: onDeleteCustomField,
    handleEditCustomField: onEditCustomField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 691,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 704,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 706,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 707,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_templates.Templates, {
    templates: templates,
    isLoading: isLoadingCaseConfiguration,
    disabled: isLoadingCaseConfiguration,
    onAddTemplate: () => setFlyOutVisibility({
      type: 'template',
      visible: true
    }),
    onEditTemplate: onEditTemplate,
    onDeleteTemplate: onDeleteTemplate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 708,
      columnNumber: 15
    }
  }))), hasMinimumLicensePermissionsForObservables && isObservablesFeatureEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 721,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 723,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 724,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_observable_types.ObservableTypes, {
    observableTypes: observableTypes,
    isLoading: isLoadingCaseConfiguration,
    disabled: isLoadingCaseConfiguration,
    handleAddObservableType: () => setFlyOutVisibility({
      type: 'observableTypes',
      visible: true
    }),
    handleDeleteObservableType: onDeleteObservableType,
    handleEditObservableType: onEditObservableType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 725,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 740,
      columnNumber: 11
    }
  }), ConnectorAddFlyout, ConnectorEditFlyout, AddOrEditCustomFieldFlyout, AddOrEditTemplateFlyout, AddOrEditObservableTypeFlyout)));
});
ConfigureCases.displayName = 'ConfigureCases';