"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleMathFunction = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18n2 = require("../../../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/uis/arguments/datacolumn/simple_math_function.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  DataColumn: strings
} = _i18n2.ArgumentStrings;
const SimpleMathFunction = ({
  onChange,
  value,
  onlymath
}) => {
  const options = [{
    text: strings.getOptionAverage(),
    value: 'mean'
  }, {
    text: strings.getOptionCount(),
    value: 'size'
  }, {
    text: strings.getOptionFirst(),
    value: 'first'
  }, {
    text: strings.getOptionLast(),
    value: 'last'
  }, {
    text: strings.getOptionMax(),
    value: 'max'
  }, {
    text: strings.getOptionMedian(),
    value: 'median'
  }, {
    text: strings.getOptionMin(),
    value: 'min'
  }, {
    text: strings.getOptionSum(),
    value: 'sum'
  }, {
    text: strings.getOptionUnique(),
    value: 'unique'
  }];
  if (!onlymath) {
    options.unshift({
      text: strings.getOptionValue(),
      value: ''
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    options: options,
    value: value,
    onChange: onChange,
    "aria-label": _i18n.i18n.translate('xpack.canvas.simpleMathFunction.functionSelectAriaLabel', {
      defaultMessage: 'Math function'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  });
};
exports.SimpleMathFunction = SimpleMathFunction;
SimpleMathFunction.propTypes = {
  onChange: _propTypes.default.func,
  value: _propTypes.default.string,
  onlymath: _propTypes.default.bool
};
SimpleMathFunction.defaultProps = {
  value: ''
};