"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildAlertFieldsRequest = void 0;
var _fp = require("lodash/fp");
var _fields = require("./fields");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const buildAlertFieldsRequest = (fields, excludeEcsData) => (0, _fp.uniq)([...fields.filter(field => !field.startsWith('_')), ...(excludeEcsData ? [] : _fields.ALERT_EVENTS_FIELDS)]).map(field => ({
  field,
  include_unmapped: true,
  ...(field === '@timestamp' ? {
    format: 'strict_date_optional_time'
  } : {})
}));
exports.buildAlertFieldsRequest = buildAlertFieldsRequest;