"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedPatterns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _get_category_query = require("@kbn/aiops-log-pattern-analysis/get_category_query");
var _render_custom_toolbar = require("@kbn/unified-data-table/src/components/custom_toolbar/render_custom_toolbar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/log_categorization_for_embeddable/selected_patterns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SelectedPatterns = ({
  openInDiscover
}) => {
  const {
    getLabels,
    openFunction
  } = openInDiscover;
  const labels = getLabels(false);
  const [showMenu, setShowMenu] = (0, _react.useState)(false);
  const togglePopover = () => setShowMenu(!showMenu);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiDataGridToolbarControl, {
    "data-test-subj": "aiopsEmbeddableMenuOptionsButton",
    iconType: "documents",
    onClick: () => togglePopover(),
    badgeContent: openInDiscover.count,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.aiops.logCategorization.selectedResultsButtonLabel",
    defaultMessage: "Selected",
    description: "Selected results",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    closePopover: () => setShowMenu(false),
    isOpen: showMenu,
    panelPaddingSize: "none",
    button: button,
    className: "unifiedDataTableToolbarControlButton",
    css: _render_custom_toolbar.styles.controlButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "in",
      icon: "plusInCircle",
      onClick: () => openFunction(_get_category_query.QUERY_MODE.INCLUDE, false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    }, labels.multiSelect.in), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "out",
      icon: "minusInCircle",
      onClick: () => openFunction(_get_category_query.QUERY_MODE.EXCLUDE, false),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, labels.multiSelect.out)],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }));
};
exports.SelectedPatterns = SelectedPatterns;