"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveBindingsDeactivations = resolveBindingsDeactivations;
const isScopedBinding_1 = require("../../binding/calculations/isScopedBinding");
const BindingScope_1 = require("../../binding/models/BindingScope");
const resolveBindingDeactivations_1 = require("./resolveBindingDeactivations");
const CACHE_KEY_TYPE = 'cache';
function resolveBindingsDeactivations(params, bindings) {
    if (bindings === undefined) {
        return;
    }
    const singletonScopedBindings = filterCachedSinglentonScopedBindings(bindings);
    const deactivationPromiseResults = [];
    for (const binding of singletonScopedBindings) {
        const deactivationResult = (0, resolveBindingDeactivations_1.resolveBindingDeactivations)(params, binding);
        if (deactivationResult !== undefined) {
            deactivationPromiseResults.push(deactivationResult);
        }
    }
    if (deactivationPromiseResults.length > 0) {
        return Promise.all(deactivationPromiseResults).then(() => undefined);
    }
}
function filterCachedSinglentonScopedBindings(bindings) {
    const filteredBindings = [];
    for (const binding of bindings) {
        if ((0, isScopedBinding_1.isScopedBinding)(binding) &&
            binding.scope === BindingScope_1.bindingScopeValues.Singleton &&
            binding.cache.isRight) {
            filteredBindings.push(binding);
        }
    }
    return filteredBindings;
}
//# sourceMappingURL=resolveBindingsDeactivations.js.map