"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hideScrollbars = exports.euiCollapsibleNavFooterStyles = exports.euiCollapsibleNavBodyStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Hide the scrollbar for docked mode (while still keeping the nav scrollable)
// Otherwise if scrollbars are visible, button icon visibility suffers.
var hideScrollbars = exports.hideScrollbars = "\n  scrollbar-width: none; /* Firefox */\n\n  &::-webkit-scrollbar {\n    display: none; /* Chrome, Edge, & Safari */\n  }\n";
var euiCollapsibleNavBodyStyles = exports.euiCollapsibleNavBodyStyles = {
  euiCollapsibleNav__body: /*#__PURE__*/(0, _react.css)(";label:euiCollapsibleNav__body;"),
  isPushCollapsed: /*#__PURE__*/(0, _react.css)(".euiFlyoutBody__overflow{", hideScrollbars, ";};label:isPushCollapsed;")
};
var euiCollapsibleNavFooterStyles = exports.euiCollapsibleNavFooterStyles = function euiCollapsibleNavFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiCollapsibleNav__footer: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-height', '50%'), " background-color:", euiTheme.colors.emptyShade, ";", (0, _global_styling.logicalCSS)('border-top', euiTheme.border.thin), ";;label:euiCollapsibleNav__footer;"),
    euiFlyoutFooter__overflow: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiYScrollWithShadows)(euiThemeContext, {
      side: 'end'
    }), ";;label:euiFlyoutFooter__overflow;"),
    isPushCollapsed: /*#__PURE__*/(0, _react.css)(hideScrollbars, ";;label:isPushCollapsed;")
  };
};