"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InternalPluginInitializer = exports.InternalCoreStart = exports.InternalCoreSetup = void 0;
exports.createSetupModule = createSetupModule;
exports.createStartModule = createStartModule;
var _inversify = require("inversify");
var _coreDi = require("@kbn/core-di");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal */

/** @internal */

function loadEach({
  bind
}, object, iteratee) {
  for (const [key, value] of Object.entries(object)) {
    bind(iteratee(key)).toConstantValue(value);
  }
}
function createServiceIdentifierFactory(...prefix) {
  return (...key) => Symbol.for([...prefix, key].join('.'));
}

/** @internal */
const InternalPluginInitializer = exports.InternalPluginInitializer = createServiceIdentifierFactory('plugin', 'initializer');

/** @internal */
const InternalCoreSetup = exports.InternalCoreSetup = createServiceIdentifierFactory('core', 'setup');

/** @internal */
const InternalCoreStart = exports.InternalCoreStart = createServiceIdentifierFactory('core', 'start');

/** @internal */
function createSetupModule(pluginInitializerContext, coreSetupContext, plugins) {
  return new _inversify.ContainerModule(options => {
    loadEach(options, pluginInitializerContext, InternalPluginInitializer);
    loadEach(options, coreSetupContext, InternalCoreSetup);
    loadEach(options, plugins, _coreDi.PluginSetup);
  });
}

/** @internal */
function createStartModule(coreStartContext, plugins) {
  return new _inversify.ContainerModule(options => {
    loadEach(options, coreStartContext, InternalCoreStart);
    loadEach(options, plugins, _coreDi.PluginStart);
  });
}