"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Navigation = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _side_nav = require("./side_nav");
var _focus_main_content = require("../utils/focus_main_content");
var _get_has_submenu = require("../utils/get_has_submenu");
var _use_layout_width = require("../hooks/use_layout_width");
var _use_navigation = require("../hooks/use_navigation");
var _use_responsive_menu = require("../hooks/use_responsive_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const navigationWrapperStyles = (0, _react2.css)`
  display: flex;
`;
const Navigation = ({
  activeItemId,
  isCollapsed: isCollapsedProp,
  items,
  logo,
  onItemClick,
  setWidth,
  sidePanelFooter,
  ...rest
}) => {
  var _rest$dataTestSubj, _openerNode$sections;
  const isMobile = (0, _eui.useIsWithinBreakpoints)(['xs', 's']);
  const isCollapsed = isMobile || isCollapsedProp;
  const popoverItemPrefix = `${_constants.NAVIGATION_SELECTOR_PREFIX}-popoverItem`;
  const popoverFooterItemPrefix = `${_constants.NAVIGATION_SELECTOR_PREFIX}-popoverFooterItem`;
  const sidePanelItemPrefix = `${_constants.NAVIGATION_SELECTOR_PREFIX}-sidePanelItem`;
  const moreMenuTriggerTestSubj = `${_constants.NAVIGATION_SELECTOR_PREFIX}-moreMenuTrigger`;
  const {
    actualActiveItemId,
    visuallyActivePageId,
    visuallyActiveSubpageId,
    isSidePanelOpen,
    openerNode
  } = (0, _use_navigation.useNavigation)(isCollapsed, items, logo.id, activeItemId);
  const {
    overflowMenuItems,
    primaryMenuRef,
    visibleMenuItems
  } = (0, _use_responsive_menu.useResponsiveMenu)(isCollapsed, items.primaryItems);
  (0, _use_layout_width.useLayoutWidth)({
    isCollapsed,
    isSidePanelOpen,
    setWidth
  });
  const [isAnyPopoverOpen, setAnyPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: navigationWrapperStyles,
    "data-test-subj": (_rest$dataTestSubj = rest['data-test-subj']) !== null && _rest$dataTestSubj !== void 0 ? _rest$dataTestSubj : _constants.NAVIGATION_ROOT_SELECTOR,
    id: _constants.NAVIGATION_ROOT_SELECTOR,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_side_nav.SideNav, {
    isCollapsed: isCollapsed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Logo, (0, _extends2.default)({
    isCollapsed: isCollapsed,
    isCurrent: actualActiveItemId === logo.id,
    isHighlighted: visuallyActivePageId === logo.id,
    onClick: () => onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(logo)
  }, logo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.PrimaryMenu, {
    ref: primaryMenuRef,
    isCollapsed: isCollapsed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, visibleMenuItems.map(item => {
    const {
      sections,
      ...itemProps
    } = item;
    return /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Popover, {
      key: item.id,
      hasContent: (0, _get_has_submenu.getHasSubmenu)(item),
      isAnyPopoverOpen: isAnyPopoverOpen,
      isSidePanelOpen: !isCollapsed && item.id === (openerNode === null || openerNode === void 0 ? void 0 : openerNode.id),
      label: item.label,
      setAnyPopoverOpen: setAnyPopoverOpen,
      trigger: /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.PrimaryMenu.Item, (0, _extends2.default)({
        hasContent: (0, _get_has_submenu.getHasSubmenu)(item),
        isCollapsed: isCollapsed,
        isCurrent: actualActiveItemId === item.id,
        isHighlighted: item.id === visuallyActivePageId,
        onClick: () => onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(item)
      }, itemProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 19
        }
      }), item.label),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 15
      }
    }, closePopover => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SecondaryMenu, {
      title: item.label,
      badgeType: item.badgeType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 19
      }
    }, sections === null || sections === void 0 ? void 0 : sections.map(section => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SecondaryMenu.Section, {
      key: section.id,
      label: section.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 23
      }
    }, section.items.map(subItem => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SecondaryMenu.Item, (0, _extends2.default)({
      key: subItem.id,
      isHighlighted: subItem.id === visuallyActiveSubpageId,
      isCurrent: actualActiveItemId === subItem.id,
      onClick: () => {
        onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(subItem);
        if (subItem.href) {
          closePopover();
        }
      },
      testSubjPrefix: popoverItemPrefix
    }, subItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 27
      }
    }), subItem.label))))));
  }), overflowMenuItems.length > 0 && /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Popover, {
    hasContent: true,
    isAnyPopoverOpen: isAnyPopoverOpen,
    isSidePanelOpen: false,
    label: _i18n.i18n.translate('core.ui.chrome.sideNavigation.moreMenuLabel', {
      defaultMessage: 'More'
    }),
    persistent: true,
    setAnyPopoverOpen: setAnyPopoverOpen,
    trigger: /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.PrimaryMenu.Item, {
      "data-test-subj": moreMenuTriggerTestSubj,
      hasContent: true,
      iconType: "boxesVertical",
      id: _constants.MORE_MENU_ID,
      isCollapsed: isCollapsed,
      isHighlighted: overflowMenuItems.some(item => item.id === visuallyActivePageId),
      label: _i18n.i18n.translate('core.ui.chrome.sideNavigation.moreMenuItemLabel', {
        defaultMessage: 'More'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.ui.chrome.sideNavigation.moreMenuItemText",
      defaultMessage: "More",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 19
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }, closePopover => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.NestedSecondaryMenu, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.NestedSecondaryMenu.Panel, {
    id: _constants.MAIN_PANEL_ID,
    title: _i18n.i18n.translate('core.ui.chrome.sideNavigation.nestedSecondaryMenuMoreTitle', {
      defaultMessage: 'More'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.NestedSecondaryMenu.Section, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 21
    }
  }, overflowMenuItems.map(item => {
    const hasSubmenu = (0, _get_has_submenu.getHasSubmenu)(item);
    const {
      sections,
      ...itemProps
    } = item;
    return /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.NestedSecondaryMenu.PrimaryMenuItem, (0, _extends2.default)({
      key: item.id,
      isHighlighted: item.id === visuallyActivePageId,
      hasSubmenu: hasSubmenu,
      onClick: () => {
        onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(item);
        if (!hasSubmenu) {
          closePopover();
          (0, _focus_main_content.focusMainContent)();
        }
      }
    }, itemProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 27
      }
    }), item.label);
  }))), overflowMenuItems.filter(_get_has_submenu.getHasSubmenu).map(item => {
    var _item$sections;
    return /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.NestedSecondaryMenu.Panel, {
      key: `submenu-${item.id}`,
      id: item.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.NestedSecondaryMenu.Header, {
      title: item.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 23
      }
    }), (_item$sections = item.sections) === null || _item$sections === void 0 ? void 0 : _item$sections.map(section => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.NestedSecondaryMenu.Section, {
      key: section.id,
      label: section.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 25
      }
    }, section.items.map(subItem => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.NestedSecondaryMenu.Item, (0, _extends2.default)({
      key: subItem.id,
      isHighlighted: subItem.id === visuallyActiveSubpageId,
      isCurrent: actualActiveItemId === subItem.id,
      onClick: () => {
        onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(subItem);
        closePopover();
        (0, _focus_main_content.focusMainContent)();
      }
    }, subItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 29
      }
    }), subItem.label)))));
  })))), /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Footer, {
    isCollapsed: isCollapsed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 9
    }
  }, items.footerItems.slice(0, _constants.MAX_FOOTER_ITEMS).map(item => {
    const {
      sections,
      ...itemProps
    } = item;
    return /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Popover, {
      key: item.id,
      hasContent: (0, _get_has_submenu.getHasSubmenu)(item),
      isAnyPopoverOpen: isAnyPopoverOpen,
      isSidePanelOpen: !isCollapsed && item.id === (openerNode === null || openerNode === void 0 ? void 0 : openerNode.id),
      label: item.label,
      persistent: false,
      setAnyPopoverOpen: setAnyPopoverOpen,
      trigger: /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.Footer.Item, (0, _extends2.default)({
        isHighlighted: item.id === visuallyActivePageId,
        isCurrent: actualActiveItemId === item.id,
        hasContent: (0, _get_has_submenu.getHasSubmenu)(item),
        onClick: () => onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(item)
      }, itemProps, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 277,
          columnNumber: 19
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 15
      }
    }, closePopover => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SecondaryMenu, {
      title: item.label,
      badgeType: item.badgeType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 19
      }
    }, sections === null || sections === void 0 ? void 0 : sections.map(section => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SecondaryMenu.Section, {
      key: section.id,
      label: section.label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 23
      }
    }, section.items.map(subItem => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SecondaryMenu.Item, (0, _extends2.default)({
      key: subItem.id,
      isHighlighted: subItem.id === visuallyActiveSubpageId,
      isCurrent: actualActiveItemId === subItem.id,
      onClick: () => {
        onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(subItem);
        if (subItem.href) {
          closePopover();
        }
      }
    }, subItem, {
      testSubjPrefix: popoverFooterItemPrefix,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 27
      }
    }), subItem.label))))));
  }))), isSidePanelOpen && openerNode && /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SidePanel, {
    footer: sidePanelFooter,
    openerNode: openerNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SecondaryMenu, {
    badgeType: openerNode.badgeType,
    isPanel: true,
    title: openerNode.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 11
    }
  }, (_openerNode$sections = openerNode.sections) === null || _openerNode$sections === void 0 ? void 0 : _openerNode$sections.map(section => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SecondaryMenu.Section, {
    key: section.id,
    label: section.label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 15
    }
  }, section.items.map(subItem => /*#__PURE__*/_react.default.createElement(_side_nav.SideNav.SecondaryMenu.Item, (0, _extends2.default)({
    key: subItem.id,
    isCurrent: actualActiveItemId === subItem.id,
    isHighlighted: subItem.id === visuallyActiveSubpageId,
    onClick: () => onItemClick === null || onItemClick === void 0 ? void 0 : onItemClick(subItem),
    testSubjPrefix: sidePanelItemPrefix
  }, subItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 19
    }
  }), subItem.label)))))));
};
exports.Navigation = Navigation;