"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativeConnectorConfigurationConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _api = require("../../../../../common/types/api");
var _update_connector_configuration_api_logic = require("../../../../api/connector/update_connector_configuration_api_logic");
var _sync_rules_helpers = require("../../../../utils/sync_rules_helpers");
var _connector_view_logic = require("../../../connector_detail/connector_view_logic");
var _connector_filtering_logic = require("../sync_rules/connector_filtering_logic");
var _app_context = require("../../../../app_context");
var _doc_links = require("../../../shared/doc_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/connector/native_connector_configuration/native_connector_configuration_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NativeConnectorConfigurationConfig = ({
  connector,
  nativeConnector
}) => {
  const {
    hasPlatinumLicense
  } = (0, _app_context.useAppContext)();
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    status: updateStatus
  } = (0, _kea.useValues)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    hasAdvancedFilteringFeature
  } = (0, _kea.useValues)((0, _connector_view_logic.ConnectorViewLogic)({
    http
  }));
  const {
    advancedSnippet
  } = (0, _kea.useValues)((0, _connector_filtering_logic.ConnectorFilteringLogic)({
    http
  }));
  const isAdvancedSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(advancedSnippet);
  return /*#__PURE__*/_react.default.createElement(_searchConnectors.ConnectorConfigurationComponent, {
    connector: connector,
    hasPlatinumLicense: hasPlatinumLicense,
    isLoading: updateStatus === _api.Status.LOADING,
    saveConfig: configuration => makeRequest({
      configuration,
      connectorId: connector.id,
      http
    }),
    subscriptionLink: _doc_links.docLinks.licenseManagement,
    stackManagementLink: http === null || http === void 0 ? void 0 : http.basePath.prepend('/app/management/stack/license_management'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, nativeConnector.externalAuthDocsUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entSearchContent-connector-nativeConnector-configNameAuthenticationLink",
    "data-telemetry-id": "entSearchContent-connector-nativeConnector-configNameAuthenticationLink",
    href: nativeConnector.externalAuthDocsUrl,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.indices.configurationConnector.nativeConnector.config.sourceSecurityDocumentationLinkLabel', {
    defaultMessage: '{name} authentication',
    values: {
      name: nativeConnector.name
    }
  })))), connector.status && hasAdvancedFilteringFeature && !isAdvancedSnippetEmpty && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.contentConnectors.content.connector_detail.configurationConnector.connectorPackage.advancedRulesCallout', {
      defaultMessage: 'Configuration warning'
    }),
    iconType: "info",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors..content.connector_detail.configurationConnector.connectorPackage.advancedRulesCallout.description",
    defaultMessage: "{advancedSyncRulesDocs} can override some configuration fields.",
    values: {
      advancedSyncRulesDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "entSearchContent-connector-nativeConnector-advancedSyncRulesDocsLink",
        "data-telemetry-id": "entSearchContent-connector-nativeConnector-advancedSyncRulesDocsLink",
        href: _doc_links.docLinks.syncRules,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.contentConnectors.content.connector_detail.configurationConnector.connectorPackage.advancedSyncRulesDocs', {
        defaultMessage: 'Advanced Sync Rules'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }))));
};
exports.NativeConnectorConfigurationConfig = NativeConnectorConfigurationConfig;