"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParamsSchema = exports.HeadersSchema = exports.ConfigSchema = void 0;
var _zod = require("@kbn/zod");
var _auth = require("../../common/auth");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HeadersSchema = exports.HeadersSchema = _zod.z.record(_zod.z.string(), _zod.z.string());
const configSchemaProps = {
  url: _zod.z.string(),
  method: _zod.z.enum([_auth.WebhookMethods.POST, _auth.WebhookMethods.PUT, _auth.WebhookMethods.PATCH, _auth.WebhookMethods.GET, _auth.WebhookMethods.DELETE]).default(_auth.WebhookMethods.POST),
  headers: HeadersSchema.nullable().default(null),
  hasAuth: _auth.AuthConfiguration.hasAuth,
  authType: _auth.AuthConfiguration.authType,
  certType: _auth.AuthConfiguration.certType,
  ca: _auth.AuthConfiguration.ca,
  verificationMode: _auth.AuthConfiguration.verificationMode,
  accessTokenUrl: _auth.AuthConfiguration.accessTokenUrl,
  clientId: _auth.AuthConfiguration.clientId,
  scope: _auth.AuthConfiguration.scope,
  additionalFields: _auth.AuthConfiguration.additionalFields
};
const ConfigSchema = exports.ConfigSchema = _zod.z.object(configSchemaProps).strict();
const ParamsSchema = exports.ParamsSchema = _zod.z.object({
  body: _zod.z.string().optional()
}).strict();