"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityTablePanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _vulnerability_table_panel = require("./vulnerability_table_panel.config");
var _chart_panel = require("../../components/chart_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerability_dashboard/vulnerability_table_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const VulnerabilityTablePanel = ({
  items,
  columns,
  tableType,
  onViewVulnerabilitiesClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    title,
    viewAllLinkText
  } = _vulnerability_table_panel.vulnerabilityDashboardTableContent[tableType];
  return /*#__PURE__*/_react.default.createElement(_chart_panel.ChartPanel, {
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "justify-content": "space-between",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: "vulnerabilityTable",
    css: (0, _react2.css)`
              & .euiTableHeaderCell {
                border-bottom: ${euiTheme.border.width.thick} solid ${euiTheme.colors.darkestShade};
              }
            `,
    items: items,
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: (0, _react2.css)`
              width: fit-content;
            `,
    iconType: "search",
    onClick: onViewVulnerabilitiesClick,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, viewAllLinkText))));
};
exports.VulnerabilityTablePanel = VulnerabilityTablePanel;