"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeShapeSchema = exports.nodeDocumentDataSchema = exports.nodeColorSchema = exports.nodeBaseDataSchema = exports.labelNodeDataSchema = exports.groupNodeDataSchema = exports.graphResponseSchema = exports.graphRequestSchema = exports.entitySchema = exports.entityNodeDataSchema = exports.edgeDataSchema = exports.edgeColorSchema = exports.REACHED_NODES_LIMIT = exports.INDEX_PATTERN_REGEX = exports.DOCUMENT_TYPE_EVENT = exports.DOCUMENT_TYPE_ENTITY = exports.DOCUMENT_TYPE_ALERT = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_PATTERN_REGEX = exports.INDEX_PATTERN_REGEX = /^[^A-Z^\\/?"<>|\s#,]+$/;
const graphRequestSchema = exports.graphRequestSchema = _configSchema.schema.object({
  nodesLimit: _configSchema.schema.maybe(_configSchema.schema.number()),
  showUnknownTarget: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  query: _configSchema.schema.object({
    originEventIds: _configSchema.schema.arrayOf(_configSchema.schema.object({
      id: _configSchema.schema.string(),
      isAlert: _configSchema.schema.boolean()
    })),
    // TODO: use zod for range validation instead of config schema
    start: _configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()]),
    end: _configSchema.schema.oneOf([_configSchema.schema.number(), _configSchema.schema.string()]),
    indexPatterns: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1,
      validate: value => {
        if (!INDEX_PATTERN_REGEX.test(value)) {
          return `Invalid index pattern: ${value}. Contains illegal characters.`;
        }
      }
    }), {
      minSize: 1
    })),
    esQuery: _configSchema.schema.maybe(_configSchema.schema.object({
      bool: _configSchema.schema.object({
        filter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        }))),
        must: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        }))),
        should: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        }))),
        must_not: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({}, {
          unknowns: 'allow'
        })))
      })
    }))
  })
});
const DOCUMENT_TYPE_EVENT = exports.DOCUMENT_TYPE_EVENT = 'event';
const DOCUMENT_TYPE_ALERT = exports.DOCUMENT_TYPE_ALERT = 'alert';
const DOCUMENT_TYPE_ENTITY = exports.DOCUMENT_TYPE_ENTITY = 'entity';
const entitySchema = exports.entitySchema = _configSchema.schema.object({
  name: _configSchema.schema.maybe(_configSchema.schema.string()),
  type: _configSchema.schema.maybe(_configSchema.schema.string()),
  sub_type: _configSchema.schema.maybe(_configSchema.schema.string()),
  host: _configSchema.schema.maybe(_configSchema.schema.object({
    ip: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
});
const nodeDocumentDataSchema = exports.nodeDocumentDataSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.oneOf([_configSchema.schema.literal(DOCUMENT_TYPE_EVENT), _configSchema.schema.literal(DOCUMENT_TYPE_ALERT), _configSchema.schema.literal(DOCUMENT_TYPE_ENTITY)]),
  index: _configSchema.schema.maybe(_configSchema.schema.string()),
  event: _configSchema.schema.maybe(_configSchema.schema.object({
    id: _configSchema.schema.string()
  })),
  alert: _configSchema.schema.maybe(_configSchema.schema.object({
    ruleName: _configSchema.schema.maybe(_configSchema.schema.string())
  })),
  entity: _configSchema.schema.maybe(entitySchema)
});
const REACHED_NODES_LIMIT = exports.REACHED_NODES_LIMIT = 'REACHED_NODES_LIMIT';
const graphResponseSchema = () => _configSchema.schema.object({
  nodes: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([entityNodeDataSchema, groupNodeDataSchema, labelNodeDataSchema])),
  edges: _configSchema.schema.arrayOf(edgeDataSchema),
  messages: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(REACHED_NODES_LIMIT)])))
});
exports.graphResponseSchema = graphResponseSchema;
const nodeColorSchema = exports.nodeColorSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('primary'), _configSchema.schema.literal('danger'), _configSchema.schema.literal('warning')]);
const edgeColorSchema = exports.edgeColorSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('primary'), _configSchema.schema.literal('danger'), _configSchema.schema.literal('warning'), _configSchema.schema.literal('subdued')]);
const nodeShapeSchema = exports.nodeShapeSchema = _configSchema.schema.oneOf([_configSchema.schema.literal('hexagon'), _configSchema.schema.literal('pentagon'), _configSchema.schema.literal('ellipse'), _configSchema.schema.literal('rectangle'), _configSchema.schema.literal('diamond'), _configSchema.schema.literal('label'), _configSchema.schema.literal('group')]);
const nodeBaseDataSchema = exports.nodeBaseDataSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  label: _configSchema.schema.maybe(_configSchema.schema.string()),
  icon: _configSchema.schema.maybe(_configSchema.schema.string())
});
const entityNodeDataSchema = exports.entityNodeDataSchema = _configSchema.schema.allOf([nodeBaseDataSchema, _configSchema.schema.object({
  color: nodeColorSchema,
  shape: _configSchema.schema.oneOf([_configSchema.schema.literal('hexagon'), _configSchema.schema.literal('pentagon'), _configSchema.schema.literal('ellipse'), _configSchema.schema.literal('rectangle'), _configSchema.schema.literal('diamond')]),
  tag: _configSchema.schema.maybe(_configSchema.schema.string()),
  count: _configSchema.schema.maybe(_configSchema.schema.number()),
  ips: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  countryCodes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  documentsData: _configSchema.schema.maybe(_configSchema.schema.arrayOf(nodeDocumentDataSchema))
})]);
const groupNodeDataSchema = exports.groupNodeDataSchema = _configSchema.schema.allOf([nodeBaseDataSchema, _configSchema.schema.object({
  shape: _configSchema.schema.literal('group')
})]);
const labelNodeDataSchema = exports.labelNodeDataSchema = _configSchema.schema.allOf([nodeBaseDataSchema, _configSchema.schema.object({
  shape: _configSchema.schema.literal('label'),
  parentId: _configSchema.schema.maybe(_configSchema.schema.string()),
  color: nodeColorSchema,
  ips: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  count: _configSchema.schema.maybe(_configSchema.schema.number()),
  uniqueEventsCount: _configSchema.schema.maybe(_configSchema.schema.number()),
  uniqueAlertsCount: _configSchema.schema.maybe(_configSchema.schema.number()),
  countryCodes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  documentsData: _configSchema.schema.maybe(_configSchema.schema.arrayOf(nodeDocumentDataSchema))
})]);
const edgeDataSchema = exports.edgeDataSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  source: _configSchema.schema.string(),
  target: _configSchema.schema.string(),
  color: edgeColorSchema,
  type: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('solid'), _configSchema.schema.literal('dashed')]))
});