"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _interpreter = require("@kbn/interpreter");
var _arg_add_popover = require("../components/arg_add_popover");
var _sidebar_section = require("../components/sidebar/sidebar_section");
var _sidebar_section_title = require("../components/sidebar/sidebar_section_title");
var _base_form = require("./base_form");
var _arg = require("./arg");
var _ = require(".");
var _args = require("../lib/args");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/expression_types/function_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error unconverted components
// @ts-expect-error unconverted components
class FunctionForm extends _base_form.BaseForm {
  constructor(props) {
    super({
      ...props
    });
    /**
     * UI arguments config
     */
    (0, _defineProperty2.default)(this, "args", void 0);
    (0, _defineProperty2.default)(this, "resolve", void 0);
    this.args = props.args || [];
    this.resolve = props.resolve || (() => ({}));
  }
  renderArg(argWithValues, props) {
    const {
      onValueRemove,
      onValueChange,
      onContainerRemove,
      id,
      ...passedProps
    } = props;
    const {
      arg,
      argValues
    } = argWithValues;
    // TODO: show some information to the user than an argument was skipped
    if (!arg) {
      return null;
    }
    const renderArgWithProps = (argValue, valueIndex) => arg.render({
      key: `${id}.${arg.name}.${valueIndex}`,
      ...passedProps,
      valueIndex,
      onValueChange: onValueChange(arg.name, valueIndex),
      onValueRemove: onValueRemove(arg.name, valueIndex),
      argValue: argValue !== null && argValue !== void 0 ? argValue : null
    });

    // render the argument's template, wrapped in a remove control
    // if the argument is required but not included, render the control anyway
    if (!argValues && arg.required) {
      return renderArgWithProps(null, 0);
    }

    // render all included argument controls
    return argValues && argValues.map(renderArgWithProps);
  }
  getArgDescription({
    name,
    displayName,
    help
  }, argUiConfig) {
    var _ref, _argUiConfig$name, _argUiConfig$displayN, _argUiConfig$help;
    return {
      name: (_ref = (_argUiConfig$name = argUiConfig.name) !== null && _argUiConfig$name !== void 0 ? _argUiConfig$name : name) !== null && _ref !== void 0 ? _ref : '',
      displayName: (_argUiConfig$displayN = argUiConfig.displayName) !== null && _argUiConfig$displayN !== void 0 ? _argUiConfig$displayN : displayName,
      help: (_argUiConfig$help = argUiConfig.help) !== null && _argUiConfig$help !== void 0 ? _argUiConfig$help : help
    };
  }
  getAddableArgComplex(argUiConfig, argValues, onValueAdd) {
    if (argValues && !argUiConfig.multi) {
      return null;
    }
    const argExpression = (0, _args.buildDefaultArgExpr)(argUiConfig);
    const arg = (0, _args.getArgTypeDef)(argUiConfig.argType);
    if (!arg || argExpression === undefined) {
      return null;
    }
    const value = argExpression === null ? null : (0, _interpreter.fromExpression)(argExpression, 'argument');
    return {
      ...this.getArgDescription(arg, argUiConfig),
      onValueAdd: onValueAdd(argUiConfig.name, value)
    };
  }
  getAddableArgSimple(argUiConfig, argValues, onValueAdd) {
    const arg = new _arg.Arg(argUiConfig);

    // skip arguments that aren't defined in the expression type schema
    if (!arg || arg.required) {
      return null;
    }
    if (argValues && !arg.multi) {
      return null;
    }
    const value = arg.default === null || arg.default === undefined ? null : (0, _interpreter.fromExpression)(arg.default, 'argument');
    return {
      ...this.getArgDescription(arg, argUiConfig),
      onValueAdd: onValueAdd(arg.name, value)
    };
  }
  getAddableArgs(simpleFunctionArgs = {}, nestedFunctionsArgs = {}, onValueAdd) {
    const simpleArgs = simpleFunctionArgs === null ? {} : simpleFunctionArgs;
    const complexArgs = nestedFunctionsArgs === null ? {} : nestedFunctionsArgs;
    const addableArgs = this.args.reduce((addable, arg) => {
      if (!arg.type || arg.type === 'argument') {
        const addableArg = this.getAddableArgSimple(arg, simpleArgs[arg.name], onValueAdd);
        return addableArg ? [...addable, addableArg] : addable;
      }
      const addableArg = this.getAddableArgComplex(arg, complexArgs[arg.name], onValueAdd);
      return addableArg ? [...addable, addableArg] : addable;
    }, []);
    return addableArgs;
  }
  getArgsWithValues(args, argTypeDef) {
    let argInstances = [];
    if (this.isExpressionFunctionForm(argTypeDef)) {
      const argNames = argTypeDef.args.map(({
        name
      }) => name);
      argInstances = this.args.filter(arg => argNames.includes(arg.name)).map(argSpec => new _arg.Arg(argSpec));
    } else {
      argInstances = this.args.map(argSpec => new _arg.Arg(argSpec));
    }
    if (args === null || !(0, _lodash.isPlainObject)(args)) {
      throw new Error(`Form "${this.name}" expects "args" object`);
    }
    // get a mapping of arg values from the expression and from the renderable's schema
    const argNames = (0, _lodash.uniq)(this.args.map(arg => arg.name).concat(Object.keys(args)));
    return argNames.map(argName => {
      var _last;
      const arg = argInstances.find(argument => argument.name === argName);
      // if arg is not multi, only preserve the last value found
      // otherwise, leave the value alone (including if the arg is not defined)
      const isMulti = arg && arg.multi;
      const argValues = args[argName] && !isMulti ? [(_last = (0, _lodash.last)(args[argName])) !== null && _last !== void 0 ? _last : null] : args[argName];
      return {
        arg,
        argValues
      };
    });
  }
  resolveArg(...args) {
    // basically a no-op placeholder
    return {};
  }
  isExpressionFunctionForm(argTypeDef) {
    return !!argTypeDef && (argTypeDef instanceof _.View || argTypeDef instanceof _.Model || argTypeDef instanceof _.Transform);
  }
  render(data = {
    args: null,
    argTypeDef: undefined
  }) {
    const {
      args,
      argTypeDef,
      nestedFunctionsArgs = {},
      removable
    } = data;
    const argsWithValues = this.getArgsWithValues(args, argTypeDef);
    try {
      // props are passed to resolve and the returned object is mixed into the template props
      const props = {
        ...data,
        resolved: this.resolve(data),
        typeInstance: this
      };

      // allow a hook to override the data args
      const resolvedArgsWithValues = argsWithValues.map(argWithValues => ({
        ...argWithValues,
        ...this.resolveArg(argWithValues, props)
      }));
      const argumentForms = (0, _lodash.compact)(resolvedArgsWithValues.map(argWithValues => this.renderArg(argWithValues, props)));
      const addableArgs = this.getAddableArgs(args, nestedFunctionsArgs, props.onValueAdd);
      if (!addableArgs.length && !argumentForms.length) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_sidebar_section.SidebarSection, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 258,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_sidebar_section_title.SidebarSectionTitle, {
        title: argTypeDef === null || argTypeDef === void 0 ? void 0 : argTypeDef.displayName,
        tip: argTypeDef === null || argTypeDef === void 0 ? void 0 : argTypeDef.help,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 261,
          columnNumber: 15
        }
      }, removable && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: 'Remove',
        disableScreenReaderOutput: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 263,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        color: "text",
        onClick: () => {
          props.onContainerRemove();
        },
        iconType: "cross",
        iconSize: "s",
        "aria-label": 'Remove',
        className: "canvasArg__remove",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 21
        }
      })), addableArgs.length === 0 ? null : /*#__PURE__*/_react.default.createElement(_arg_add_popover.ArgAddPopover, {
        options: addableArgs,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 276,
          columnNumber: 52
        }
      })))), argumentForms);
    } catch (e) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "danger",
        iconType: "cross",
        title: "Expression rendering error",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 286,
          columnNumber: 11
        }
      }, e.message));
    }
  }
}
exports.FunctionForm = FunctionForm;