"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Expression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _interpreter = require("@kbn/interpreter");
var _workpad = require("../../state/selectors/workpad");
var _elements = require("../../state/actions/elements");
var _element_not_selected = require("./element_not_selected");
var _expression = require("./expression");
var _canvas_expressions_service = require("../../services/canvas_expressions_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/expression/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error
// @ts-expect-error
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Expression = ({
  done
}) => {
  const {
    element,
    pageId
  } = (0, _reactRedux.useSelector)(state => ({
    pageId: (0, _workpad.getSelectedPage)(state),
    element: (0, _workpad.getSelectedElement)(state)
  }));
  if (!element) {
    return /*#__PURE__*/_react.default.createElement(_element_not_selected.ElementNotSelected, {
      done: done,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(ExpressionContainer, {
    key: element.id,
    done: done,
    element: element,
    pageId: pageId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 10
    }
  });
};
exports.Expression = Expression;
const ExpressionContainer = ({
  done,
  element,
  pageId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [isCompact, setCompact] = (0, _react.useState)(true);
  const toggleCompactView = (0, _react.useCallback)(() => {
    setCompact(!isCompact);
  }, [isCompact, setCompact]);
  const dispatchSetExpression = (0, _react.useCallback)(expression => {
    // destroy the context cache
    dispatch((0, _elements.flushContext)(element.id));

    // update the element's expression
    dispatch((0, _elements.setExpression)(expression, element.id, pageId));
  }, [dispatch, element, pageId]);
  const [formState, setFormState] = (0, _react.useState)({
    dirty: false,
    expression: element.expression
  });
  const updateValue = (0, _react.useCallback)((expression = '') => {
    setFormState({
      expression,
      dirty: true
    });
  }, [setFormState]);
  const onSetExpression = (0, _react.useCallback)(expression => {
    setFormState({
      ...formState,
      dirty: false
    });
    dispatchSetExpression(expression);
  }, [setFormState, dispatchSetExpression, formState]);
  const currentExpression = formState.expression;
  const error = (0, _react.useMemo)(() => {
    try {
      // TODO: We should merge the advanced UI input and this into a single validated expression input.
      (0, _interpreter.fromExpression)(currentExpression);
      return null;
    } catch (e) {
      return e.message;
    }
  }, [currentExpression]);
  (0, _react.useEffect)(() => {
    if (element.expression !== formState.expression && !formState.dirty) {
      setFormState({
        dirty: false,
        expression: element.expression
      });
    }
  }, [element, setFormState, formState]);
  const functionDefinitions = (0, _react.useMemo)(() => Object.values((0, _canvas_expressions_service.getCanvasExpressionService)().getFunctions()), []);
  return /*#__PURE__*/_react.default.createElement(_expression.Expression, {
    done: done,
    isCompact: isCompact,
    functionDefinitions: functionDefinitions,
    formState: formState,
    setExpression: onSetExpression,
    toggleCompactView: toggleCompactView,
    updateValue: updateValue,
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  });
};