"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isErrorMessageWithLink = exports.MessageLink = exports.ErrorMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/steps/data_stream_step/error_with_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const isErrorMessageWithLink = error => {
  return error.link !== undefined && error.linkText !== undefined && error.errorMessage !== undefined;
};
exports.isErrorMessageWithLink = isErrorMessageWithLink;
const MessageLink = exports.MessageLink = /*#__PURE__*/_react.default.memo(({
  link,
  linkText
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: link,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, linkText);
});
MessageLink.displayName = 'MessageLink';
const ErrorMessage = exports.ErrorMessage = /*#__PURE__*/_react.default.memo(({
  error
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isErrorMessageWithLink(error) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.automaticImport.createIntegration.generateErrorWithLink",
    defaultMessage: "{errorMessage} {link}",
    values: {
      errorMessage: error.errorMessage,
      link: /*#__PURE__*/_react.default.createElement(MessageLink, {
        link: error.link,
        linkText: error.linkText,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 19
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }) : typeof error === 'string' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error) : null);
});
ErrorMessage.displayName = 'ErrorMessage';