"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthorizationWrapper = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_authorization = require("../../hooks/use_authorization");
var _missing_privileges_description = require("./missing_privileges_description");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/common/components/authorization/authorization_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AuthorizationWrapper = exports.AuthorizationWrapper = /*#__PURE__*/_react.default.memo(({
  children,
  ...authRequired
}) => {
  const authorization = (0, _use_authorization.useAuthorization)();
  const isAuthorized = (0, _react.useMemo)(() => Object.entries(authRequired).every(([key, enabled]) => !enabled || authorization[key]), [authorization, authRequired]);
  if (!isAuthorized) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: false,
      title: i18n.PRIVILEGES_MISSING_TITLE,
      iconType: "info",
      "data-test-subj": "missingPrivilegesCallOut",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_missing_privileges_description.MissingPrivilegesDescription, (0, _extends2.default)({}, authRequired, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
AuthorizationWrapper.displayName = 'AuthorizationWrapper';