"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionCharts = TransactionCharts;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _annotations_context = require("../../../../context/annotations/annotations_context");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _service_overview_throughput_chart = require("../../../app/service_overview/service_overview_throughput_chart");
var _latency_chart = require("../latency_chart");
var _transaction_breakdown_chart = require("../transaction_breakdown_chart");
var _transaction_coldstart_rate_chart = require("../transaction_coldstart_rate_chart");
var _failed_transaction_rate_chart = require("../failed_transaction_rate_chart");
var _top_errors = require("../../../app/transaction_details/top_errors");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _agent_name = require("../../../../../common/agent_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/transaction_charts/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TransactionCharts({
  kuery,
  environment,
  start,
  end,
  serviceName,
  transactionName,
  isServerlessContext,
  comparisonEnabled,
  offset
}) {
  // The default EuiFlexGroup breaks at 768, but we want to break at 1200
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const {
    agentName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const isOpenTelemetryAgent = (0, _agent_name.isOpenTelemetryAgentName)(agentName);
  const isRumAgent = (0, _agent_name.isRumAgentName)(agentName);
  const isMobileAgent = (0, _agent_name.isMobileAgentName)(agentName);
  const rowDirection = isLarge ? 'column' : 'row';
  const latencyChart = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-cy": `transaction-duration-charts`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_latency_chart.LatencyChart, {
    kuery: kuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })));
  const serviceOverviewThroughputChart = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      flexShrink: 1
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_throughput_chart.ServiceOverviewThroughputChart, {
    kuery: kuery,
    transactionName: transactionName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
  const coldStartRateOrBreakdownChart = isServerlessContext ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_coldstart_rate_chart.TransactionColdstartRateChart, {
    kuery: kuery,
    transactionName: transactionName,
    environment: environment,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  })) : !isOpenTelemetryAgent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_breakdown_chart.TransactionBreakdownChart, {
    kuery: kuery,
    environment: environment,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }));
  const failedTransactionRateChart = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_failed_transaction_rate_chart.FailedTransactionRateChart, {
    kuery: kuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_annotations_context.AnnotationsContextProvider, {
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, transactionName ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }, latencyChart, serviceOverviewThroughputChart, !isMobileAgent && coldStartRateOrBreakdownChart), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 15
    }
  }, failedTransactionRateChart, !isOpenTelemetryAgent && !isRumAgent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_top_errors.TopErrors, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 23
    }
  }))))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }, latencyChart, serviceOverviewThroughputChart), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }, failedTransactionRateChart, coldStartRateOrBreakdownChart)))));
}