"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEditCustomLinkFlyout = CreateEditCustomLinkFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_plugin_context = require("../../../../../context/apm_plugin/use_apm_plugin_context");
var _filters_section = require("./filters_section");
var _flyout_footer = require("./flyout_footer");
var _link_section = require("./link_section");
var _save_custom_link = require("./save_custom_link");
var _link_preview = require("./link_preview");
var _documentation = require("./documentation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/custom_link/create_edit_custom_link_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const filtersEmptyState = [{
  key: '',
  value: ''
}];
function CreateEditCustomLinkFlyout({
  onClose,
  onSave,
  onDelete,
  defaults,
  customLinkId
}) {
  var _defaults$filters;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [label, setLabel] = (0, _react.useState)((defaults === null || defaults === void 0 ? void 0 : defaults.label) || '');
  const [url, setUrl] = (0, _react.useState)((defaults === null || defaults === void 0 ? void 0 : defaults.url) || '');
  const [filters, setFilters] = (0, _react.useState)(defaults !== null && defaults !== void 0 && (_defaults$filters = defaults.filters) !== null && _defaults$filters !== void 0 && _defaults$filters.length ? defaults.filters : filtersEmptyState);
  const isFormValid = !!label && !!url;
  const onSubmit = async event => {
    event.preventDefault();
    setIsSaving(true);
    await (0, _save_custom_link.saveCustomLink)({
      id: customLinkId,
      label,
      url,
      filters,
      toasts
    });
    setIsSaving(false);
    onSave();
  };
  return /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: onSubmit,
    id: "customLink_form",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    size: "m",
    "aria-labelledby": modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.title', {
    defaultMessage: 'Create link'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.label', {
    defaultMessage: 'Links will be available in the context of transaction details throughout the APM app. You can create an unlimited number of links. You can refer to dynamic variables by using any of the transaction metadata to fill in your URLs. More information, including examples, are available in the'
  }), ' ', /*#__PURE__*/_react.default.createElement(_documentation.Documentation, {
    label: _i18n.i18n.translate('xpack.apm.settings.customLink.flyout.label.doc', {
      defaultMessage: 'documentation.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_link_section.LinkSection, {
    label: label,
    onChangeLabel: setLabel,
    url: url,
    onChangeUrl: setUrl,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_filters_section.FiltersSection, {
    filters: filters,
    onChangeFilters: setFilters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_link_preview.LinkPreview, {
    label: label,
    url: url,
    filters: filters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_flyout_footer.FlyoutFooter, {
    isSaveButtonEnabled: isFormValid,
    onClose: onClose,
    isSaving: isSaving,
    onDelete: onDelete,
    customLinkId: customLinkId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  })));
}