"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetection = AnomalyDetection;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _anomaly_detection = require("../../../../../common/anomaly_detection");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _jobs_list = require("./jobs_list");
var _add_environments = require("./add_environments");
var _license_prompt = require("../../../shared/license_prompt");
var _use_license_context = require("../../../../context/license/use_license_context");
var _use_anomaly_detection_jobs_context = require("../../../../context/anomaly_detection_jobs/use_anomaly_detection_jobs_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/anomaly_detection/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AnomalyDetection() {
  var _plugin$core$applicat;
  const plugin = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canGetJobs = !!((_plugin$core$applicat = plugin.core.application.capabilities.ml) !== null && _plugin$core$applicat !== void 0 && _plugin$core$applicat.canGetJobs);
  const license = (0, _use_license_context.useLicenseContext)();
  const hasValidLicense = (license === null || license === void 0 ? void 0 : license.isActive) && (license === null || license === void 0 ? void 0 : license.hasAtLeast('platinum'));
  const [viewAddEnvironments, setViewAddEnvironments] = (0, _react.useState)(false);
  const {
    anomalyDetectionJobsStatus,
    anomalyDetectionJobsRefetch,
    anomalyDetectionJobsData = {
      jobs: [],
      hasLegacyJobs: false
    },
    anomalyDetectionSetupState
  } = (0, _use_anomaly_detection_jobs_context.useAnomalyDetectionJobsContext)();
  if (!hasValidLicense) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      text: _anomaly_detection.ML_ERRORS.INVALID_LICENSE,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }));
  }
  if (!canGetJobs) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _anomaly_detection.ML_ERRORS.MISSING_READ_PRIVILEGES),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, viewAddEnvironments ? /*#__PURE__*/_react.default.createElement(_add_environments.AddEnvironments, {
    currentEnvironments: anomalyDetectionJobsData.jobs.map(({
      environment
    }) => environment),
    onCreateJobSuccess: () => {
      anomalyDetectionJobsRefetch();
      setViewAddEnvironments(false);
    },
    onCancel: () => {
      setViewAddEnvironments(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_jobs_list.JobsList, {
    data: anomalyDetectionJobsData,
    status: anomalyDetectionJobsStatus,
    setupState: anomalyDetectionSetupState,
    onAddEnvironments: () => {
      setViewAddEnvironments(true);
    },
    onUpdateComplete: () => {
      anomalyDetectionJobsRefetch();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }));
}