"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexTemplatesStatus = IndexTemplatesStatus;
exports.getIsIndexTemplateOk = getIsIndexTemplateOk;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_diagnostics = require("../context/use_diagnostics");
var _tab_status = require("./tab_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/diagnostics/summary_tab/index_templates_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function IndexTemplatesStatus() {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/diagnostics/*');
  const {
    diagnosticsBundle,
    status
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  const isLoading = status === _public.FETCH_STATUS.LOADING;
  const tabStatus = getIsIndexTemplateOk(diagnosticsBundle);
  return /*#__PURE__*/_react.default.createElement(_tab_status.TabStatus, {
    isLoading: isLoading,
    isOk: tabStatus,
    "data-test-subj": "indexTemplatesStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, "Index templates", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmIndexTemplatesStatusSeeDetailsLink",
    href: router.link('/diagnostics/index-templates', {
      query
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, "See details"));
}
function getIsIndexTemplateOk(diagnosticsBundle) {
  var _diagnosticsBundle$ap;
  if (!diagnosticsBundle) {
    return true;
  }
  const hasNonStandardIndexTemplates = (_diagnosticsBundle$ap = diagnosticsBundle.apmIndexTemplates) === null || _diagnosticsBundle$ap === void 0 ? void 0 : _diagnosticsBundle$ap.some(({
    isNonStandard
  }) => isNonStandard);
  const isEveryExpectedApmIndexTemplateInstalled = diagnosticsBundle.apmIndexTemplates.every(({
    exists,
    isNonStandard
  }) => isNonStandard || exists);
  return isEveryExpectedApmIndexTemplateInstalled && !hasNonStandardIndexTemplates;
}