"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBorderSide = exports.euiShadowFloatingBorderStyles = exports.euiBorderStyles = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var logicalSide = {
  left: 'inline-start',
  right: 'inline-end',
  top: 'block-start',
  bottom: 'block-end',
  horizontal: 'inline',
  vertical: 'block'
};
var getBorderSide = exports.getBorderSide = function getBorderSide(side) {
  return side === 'all' ? 'border' : "border-".concat(logicalSide[side]);
};
/**
 * Defines styles for floating boarders applied in DARK mode via EUI shadow utils
 */
var euiShadowFloatingBorderStyles = exports.euiShadowFloatingBorderStyles = function euiShadowFloatingBorderStyles(euiThemeContext, options) {
  return "\n    /* create a containing block without using `position` to prevent CSS specificity issues and unexpected overrides;\n    `transform: translateZ(0)` is the least likely to affect other behaviors (overflow, layout) */\n    transform: translateZ(0);\n\n    ".concat(euiBorderStyles(euiThemeContext, options), "\n  ");
};

/**
 * Shared style for floating borders.
 * Uses a pseudo element with `border` attribute to prevent both dimension changes due to
 * the border width as well as visible gaps due to the need of a transparent border in LIGHT mode.
 */
var euiBorderStyles = exports.euiBorderStyles = function euiBorderStyles(euiThemeContext, options) {
  var euiTheme = euiThemeContext.euiTheme;
  var _options$side = options.side,
    side = _options$side === void 0 ? 'all' : _options$side,
    _options$borderColor = options.borderColor,
    borderColor = _options$borderColor === void 0 ? euiTheme.border.color : _options$borderColor,
    _options$borderWidth = options.borderWidth,
    borderWidth = _options$borderWidth === void 0 ? euiTheme.border.width.thin : _options$borderWidth,
    _options$borderStyle = options.borderStyle,
    borderStyle = _options$borderStyle === void 0 ? 'solid' : _options$borderStyle;
  var borderProperty = getBorderSide(side);
  return "\n    &::after {\n      content: '';\n      position: absolute;\n      inset: 0;\n      /* ensure to keep on top of flush content */\n      z-index: 0;\n      ".concat(borderProperty, ": ").concat(borderWidth, " ").concat(borderStyle, " ").concat(borderColor, ";\n      border-radius: inherit;\n      pointer-events: none;\n    }\n  ");
};