"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvalidateProvider = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/api_keys/api_keys_grid/invalidate_provider/invalidate_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const InvalidateProvider = ({
  isAdmin,
  children,
  notifications,
  apiKeysAPIClient
}) => {
  const [apiKeys, setApiKeys] = (0, _react.useState)([]);
  const [isModalOpen, setIsModalOpen] = (0, _react.useState)(false);
  const onSuccessCallback = (0, _react.useRef)(null);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const invalidateApiKeyPrompt = (keys, onSuccess = () => undefined) => {
    if (!keys || !keys.length) {
      throw new Error('No API key IDs specified for deletion');
    }
    setIsModalOpen(true);
    setApiKeys(keys);
    onSuccessCallback.current = onSuccess;
  };
  const closeModal = () => {
    setIsModalOpen(false);
    setApiKeys([]);
  };
  const invalidateApiKey = async () => {
    let result;
    let error;
    let errors;
    try {
      result = await apiKeysAPIClient.invalidateApiKeys(apiKeys, isAdmin);
    } catch (e) {
      error = e;
    }
    closeModal();
    if (result) {
      const {
        itemsInvalidated
      } = result;
      ({
        errors
      } = result);

      // Surface success notifications
      if (itemsInvalidated && itemsInvalidated.length) {
        const hasMultipleSuccesses = itemsInvalidated.length > 1;
        const successMessage = hasMultipleSuccesses ? _i18n.i18n.translate('xpack.security.management.apiKeys.deleteApiKey.successMultipleNotificationTitle', {
          defaultMessage: 'Deleted {count} API keys',
          values: {
            count: itemsInvalidated.length
          }
        }) : _i18n.i18n.translate('xpack.security.management.apiKeys.deleteApiKey.successSingleNotificationTitle', {
          defaultMessage: "Deleted API key ''{name}''",
          values: {
            name: itemsInvalidated[0].name
          }
        });
        notifications.toasts.addSuccess(successMessage);
        if (onSuccessCallback.current) {
          onSuccessCallback.current([...itemsInvalidated]);
        }
      }
    }

    // Surface error notifications
    // `error` is generic server error
    // `errors` are specific errors with removing particular API keys
    if (error || errors && errors.length) {
      const hasMultipleErrors = errors && errors.length > 1 || error && apiKeys.length > 1;
      const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.security.management.apiKeys.deleteApiKey.errorMultipleNotificationTitle', {
        defaultMessage: 'Error deleting {count} apiKeys',
        values: {
          count: errors && errors.length || apiKeys.length
        }
      }) : _i18n.i18n.translate('xpack.security.management.apiKeys.deleteApiKey.errorSingleNotificationTitle', {
        defaultMessage: "Error deleting API key ''{name}''",
        values: {
          name: errors && errors[0].name || apiKeys[0].name
        }
      });
      notifications.toasts.addDanger(errorMessage);
    }
  };
  const renderModal = () => {
    if (!isModalOpen) {
      return null;
    }
    const isSingle = apiKeys.length === 1;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      role: "dialog",
      "aria-labelledby": modalTitleId,
      title: isSingle ? _i18n.i18n.translate('xpack.security.management.apiKeys.deleteApiKey.confirmModal.deleteSingleTitle', {
        defaultMessage: "Delete API key ''{name}''?",
        values: {
          name: apiKeys[0].name
        }
      }) : _i18n.i18n.translate('xpack.security.management.apiKeys.deleteApiKey.confirmModal.deleteMultipleTitle', {
        defaultMessage: 'Delete {count} API keys?',
        values: {
          count: apiKeys.length
        }
      }),
      titleProps: {
        id: modalTitleId
      },
      onCancel: closeModal,
      onConfirm: invalidateApiKey,
      cancelButtonText: _i18n.i18n.translate('xpack.security.management.apiKeys.deleteApiKey.confirmModal.cancelButtonLabel', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.security.management.apiKeys.deleteApiKey.confirmModal.confirmButtonLabel', {
        defaultMessage: 'Delete {count, plural, one {API key} other {API keys}}',
        values: {
          count: apiKeys.length
        }
      }),
      buttonColor: "danger",
      "data-test-subj": "invalidateApiKeyConfirmationModal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 7
      }
    }, !isSingle ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.security.management.apiKeys.deleteApiKey.confirmModal.deleteMultipleListDescription', {
      defaultMessage: 'You are about to delete these API keys:'
    })), /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 13
      }
    }, apiKeys.map(({
      name,
      id
    }) => /*#__PURE__*/_react.default.createElement("li", {
      key: id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 17
      }
    }, name)))) : null);
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 5
    }
  }, children(invalidateApiKeyPrompt), renderModal());
};
exports.InvalidateProvider = InvalidateProvider;