"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkPrivileges = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkPrivileges = async (core, response) => {
  var _core$security;
  const user = (_core$security = core.security) === null || _core$security === void 0 ? void 0 : _core$security.authc.getCurrentUser();
  if (!user) {
    return response.customError({
      statusCode: 502,
      body: _i18n.i18n.translate('xpack.search.queryRules.api.routes.noUserError', {
        defaultMessage: 'Could not retrieve current user, security plugin is not ready'
      })
    });
  }
  const hasPrivilege = await core.elasticsearch.client.asCurrentUser.security.hasPrivileges({
    cluster: ['manage_search_query_rules']
  });
  if (!hasPrivilege.has_all_requested) {
    response.forbidden({
      body: _i18n.i18n.translate('xpack.search.queryRules.api.routes.permissionError', {
        defaultMessage: "You don't have manage_search_query_rules privileges"
      })
    });
  }
};
exports.checkPrivileges = checkPrivileges;