"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRulesOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _common = require("../../../common");
var _doc_links = require("../../../common/doc_links");
var _use_fetch_query_rules_sets = require("../../hooks/use_fetch_query_rules_sets");
var _empty_prompt = require("../empty_prompt/empty_prompt");
var _error_prompt = require("../error_prompt/error_prompt");
var _query_rules_utils = require("../../utils/query_rules_utils");
var _queryRuleBackground = _interopRequireDefault(require("../../assets/query-rule-background.svg"));
var _queryRuleBackgroundDark = _interopRequireDefault(require("../../assets/query-rule-background-dark.svg"));
var _query_rules_sets = require("../query_rules_sets/query_rules_sets");
var _create_ruleset_modal = require("./create_ruleset_modal");
var _query_rules_page_template = require("../../layout/query_rules_page_template");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _use_query_rules_breadcrumbs = require("../../hooks/use_query_rules_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/overview/overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryRulesOverview = () => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  (0, _use_query_rules_breadcrumbs.useQueryRulesBreadcrumbs)();
  const {
    data: queryRulesData,
    isInitialLoading,
    isError,
    error
  } = (0, _use_fetch_query_rules_sets.useFetchQueryRulesSets)();
  const [isCreateModalVisible, setIsCreateModalVisible] = (0, _react.useState)(false);
  const backgroundProps = (0, _react2.css)({
    backgroundImage: `url(${colorMode === 'DARK' ? _queryRuleBackgroundDark.default : _queryRuleBackground.default})`,
    backgroundSize: 'contain',
    backgroundRepeat: 'no-repeat',
    height: '100%',
    width: '100%',
    justifyItems: 'center',
    alignContent: 'center',
    backgroundPosition: 'center center'
  });
  return /*#__PURE__*/_react.default.createElement(_query_rules_page_template.QueryRulesPageTemplate, {
    restrictWidth: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, !isInitialLoading && !isError && (queryRulesData === null || queryRulesData === void 0 ? void 0 : queryRulesData._meta.totalItemCount) !== 0 && /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: _common.PLUGIN_TITLE,
    restrictWidth: true,
    color: "primary",
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      key: "queryRulesOverviewHeaderButtons",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "queryRulesetDetailApiReferenceButton",
      iconType: "documentation",
      color: "text",
      "aria-label": _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.apiReferenceButton', {
        defaultMessage: 'API reference'
      }),
      href: _doc_links.docLinks.queryRulesApi,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.queryRules.queryRulesetDetail.apiReferenceButton', {
      defaultMessage: 'API reference'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "queryRulesOverviewCreateButton",
      fill: true,
      iconType: "plusInCircle",
      onClick: () => {
        usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.addRulesetClicked);
        setIsCreateModalVisible(true);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.queryRules.queryRulesSetDetail.createButton",
      defaultMessage: "Create ruleset",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 19
      }
    }))))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.queryRules.queryRulesSetDetail.description",
    defaultMessage: "Create and manage query rules sets.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: true,
    contentProps: {
      css: !isInitialLoading && !isError && (queryRulesData === null || queryRulesData === void 0 ? void 0 : queryRulesData._meta.totalItemCount) !== 0 ? undefined : backgroundProps
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, isCreateModalVisible && /*#__PURE__*/_react.default.createElement(_create_ruleset_modal.CreateRulesetModal, {
    onClose: () => {
      setIsCreateModalVisible(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }), isInitialLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 30
    }
  }), isError && /*#__PURE__*/_react.default.createElement(_error_prompt.ErrorPrompt, {
    errorType: (0, _query_rules_utils.isPermissionError)(error) ? 'missingPermissions' : 'generic',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), !isInitialLoading && queryRulesData && queryRulesData._meta.totalItemCount > 0 && /*#__PURE__*/_react.default.createElement(_query_rules_sets.QueryRulesSets, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }), !isInitialLoading && queryRulesData && queryRulesData._meta.totalItemCount === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    getStartedAction: () => {
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.gettingStartedButtonClicked);
      setIsCreateModalVisible(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 15
    }
  })))));
};
exports.QueryRulesOverview = QueryRulesOverview;