"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTokenEstimate = getTokenEstimate;
exports.getTokenEstimateFromMessages = getTokenEstimateFromMessages;
var _gptTokenizer = require("gpt-tokenizer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTokenEstimate(s) {
  return (0, _gptTokenizer.encode)(s).length;
}
function getTokenEstimateFromMessages(messages) {
  return messages.reduce((acc, message) => {
    return acc + message.reduce((acc2, m) => acc2 + getTokenEstimate(m.content.toString()), 0);
  }, 0);
}