"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePageChrome = void 0;
var _react = require("react");
var _use_kibana = require("./use_kibana");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePageChrome = (docTitle, breadcrumbs, includeParentBreadcrumb = true) => {
  const {
    chrome,
    serverless
  } = (0, _use_kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    chrome.docTitle.change(docTitle);
    if (serverless) {
      serverless.setBreadcrumbs(breadcrumbs);
    } else {
      const newBreadcrumbs = includeParentBreadcrumb ? [_constants.PARENT_BREADCRUMB, ...breadcrumbs] : breadcrumbs;
      chrome.setBreadcrumbs(newBreadcrumbs, {
        project: {
          value: newBreadcrumbs,
          absolute: true
        }
      });
    }
    return () => {
      // clear manually set breadcrumbs
      if (serverless) {
        serverless.setBreadcrumbs([]);
      } else {
        chrome.setBreadcrumbs([]);
      }
    };
  }, [chrome, docTitle, serverless, breadcrumbs, includeParentBreadcrumb]);
};
exports.usePageChrome = usePageChrome;