"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validFeatureIds = exports.isValidFeatureId = exports.isSiemRuleType = exports.getSafeSortIds = exports.getEsQueryConfig = exports.DEPRECATED_ALERTING_CONSUMERS = exports.AlertConsumers = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * registering a new instance of the rule data client
 * in a new plugin will require updating the below data structure
 * to include the index name where the alerts as data will be written to.
 */

const AlertConsumers = exports.AlertConsumers = {
  APM: 'apm',
  LOGS: 'logs',
  INFRASTRUCTURE: 'infrastructure',
  OBSERVABILITY: 'observability',
  STREAMS: 'streams',
  SLO: 'slo',
  SIEM: 'siem',
  UPTIME: 'uptime',
  ML: 'ml',
  STACK_ALERTS: 'stackAlerts',
  EXAMPLE: 'AlertingExample',
  MONITORING: 'monitoring',
  ALERTS: 'alerts',
  DISCOVER: 'discover'
};
const DEPRECATED_ALERTING_CONSUMERS = exports.DEPRECATED_ALERTING_CONSUMERS = [AlertConsumers.OBSERVABILITY];
// TODO: remove 'in-progress' after migration to 'acknowledged'

const validFeatureIds = exports.validFeatureIds = Object.values(AlertConsumers).map(v => v);
const isValidFeatureId = a => typeof a === 'string' && validFeatureIds.includes(a);

/**
 * Prevent javascript from returning Number.MAX_SAFE_INTEGER when Elasticsearch expects
 * Java's Long.MAX_VALUE. This happens when sorting fields by date which are
 * unmapped in the provided index
 *
 * Ref: https://github.com/elastic/elasticsearch/issues/28806#issuecomment-369303620
 *
 * return stringified Long.MAX_VALUE if we receive Number.MAX_SAFE_INTEGER
 * @param sortIds estypes.SortResults | undefined
 * @returns SortResults
 */
exports.isValidFeatureId = isValidFeatureId;
const getSafeSortIds = sortIds => {
  if (sortIds == null) {
    return sortIds;
  }
  return sortIds.map(sortId => {
    // haven't determined when we would receive a null value for a sort id
    // but in case we do, default to sending the stringified Java max_int
    if (sortId == null || sortId === '' || Number(sortId) >= Number.MAX_SAFE_INTEGER) {
      return '9223372036854775807';
    }
    return sortId;
  });
};
exports.getSafeSortIds = getSafeSortIds;
const getEsQueryConfig = params => {
  const defaultConfigValues = {
    allowLeadingWildcards: true,
    queryStringOptions: {
      analyze_wildcard: true
    },
    ignoreFilterIfFieldNotInIndex: false,
    dateFormatTZ: 'Zulu'
  };
  if (params == null) {
    return defaultConfigValues;
  }
  const paramKeysWithValues = Object.keys(params).reduce((acc, key) => {
    const configKey = key;
    if (params[configKey] != null) {
      return {
        [key]: params[configKey],
        ...acc
      };
    }
    return {
      [key]: defaultConfigValues[configKey],
      ...acc
    };
  }, {});
  return paramKeysWithValues;
};

/**
 * TODO: Remove when checks for specific rule type ids is not needed
 *in the codebase.
 */
exports.getEsQueryConfig = getEsQueryConfig;
const isSiemRuleType = ruleTypeId => ruleTypeId.startsWith('siem.') || ruleTypeId === _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID;
exports.isSiemRuleType = isSiemRuleType;